/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Preconditions;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.util.Predefined;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;

public abstract class AbstractListener {
    protected static final String HOST_HEADER = "host";
    protected static final String REQUEST_PATH = "http.request.path";
    protected static final String HTTP_STATUS_PROP = "http.status";
    private static final AtomicInteger nextThreadId = new AtomicInteger(0);
    protected final Configuration configuration;
    protected final MuleContext muleContext;
    private static final ThreadLocal<Integer> currentThreadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextThreadId.getAndIncrement();
        }
    };
    private static final ThreadLocal<Long> outboundInvocationCounter = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static final String PROCESSOR_REGEX = "^org\\.mule\\.(module|modules)\\.(.*?)\\.(.*?)(\\.|$)";
    private static final Pattern processorPattern = Pattern.compile("^org\\.mule\\.(module|modules)\\.(.*?)\\.(.*?)(\\.|$)");

    public AbstractListener(Configuration configuration, MuleContext muleContext) {
        this.configuration = configuration;
        this.muleContext = muleContext;
    }

    protected static void incrementOutboundInvocationCounter() {
        outboundInvocationCounter.set(outboundInvocationCounter.get() + 1L);
    }

    protected static String generateOutboundInvocationId(String muleInvocationId) {
        return muleInvocationId + "/" + currentThreadId.get() + "/" + outboundInvocationCounter.get();
    }

    @Nullable
    protected static String getOperationName(Object processor) {
        if (processor instanceof DevkitBasedMessageProcessor) {
            return Predefined.tryReadStringField(processor, "operationName");
        }
        return null;
    }

    protected boolean resolveType(InvocationContext context, Object component, boolean isOutbound) {
        String processorClassName;
        Matcher matcher;
        String operationName = AbstractListener.getOperationName(component);
        if (null != operationName) {
            context.setOperation(operationName);
        }
        if ((matcher = processorPattern.matcher(processorClassName = component.getClass().getName())).find() && matcher.group(2) != null) {
            String processor2;
            NodeType nodeType2;
            String processor = matcher.group(2);
            NodeType nodeType = NodeType.getTypeFromProcessor(processor);
            if (NodeType.OTHER == nodeType && matcher.group(3) != null && NodeType.OTHER != (nodeType2 = NodeType.getTypeFromProcessor(processor2 = processor + "." + matcher.group(3)))) {
                processor = processor2;
                nodeType = nodeType2;
            }
            context.setConnector(nodeType.getProcessorName());
            String hostFromType = nodeType.getHostNameFromType(processor);
            if (isOutbound && Metrics.shouldExclude(hostFromType)) {
                return false;
            }
            context.setRemoteHost(hostFromType);
            return true;
        }
        return false;
    }

    @Nullable
    protected String getInboundPropertyAsString(MuleMessage message, String prop) {
        Object value = message.getInboundProperty(prop);
        return value == null ? null : value.toString();
    }

    @Nullable
    protected String resolveHostHeader(MuleMessage message) {
        return this.getInboundPropertyAsString(message, HOST_HEADER);
    }

    @Nullable
    protected String resolveRequestPath(MuleMessage message) {
        return this.getInboundPropertyAsString(message, REQUEST_PATH);
    }

    protected static void resetAccess(Object message) {
        if (message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)message).resetAccessControl();
        }
    }

    protected String trimInvocationId(String id) {
        Preconditions.checkNotNull((Object)id);
        if (id.length() > 36) {
            return id.substring(0, 36);
        }
        return id;
    }
}

