/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.log.AbstractLogWriter;
import com.mulesoft.analytics.collector.log.CustomMetricLogWriter;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.log.MetricV2LogWriter;
import com.mulesoft.analytics.collector.log.RawApiMetricLogWriter;
import com.mulesoft.analytics.collector.metrics.ApiMetricsCommonsProducer;
import com.mulesoft.analytics.collector.metrics.CustomMetricsCommonsProducer;
import com.mulesoft.analytics.collector.metrics.EnvironmentProvider;
import com.mulesoft.analytics.collector.metrics.FactCombiner;
import com.mulesoft.analytics.collector.metrics.GeohashMapper;
import com.mulesoft.analytics.collector.metrics.HeuristicEndpointNormalizer;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.InvocationContextToFactTransformer;
import com.mulesoft.analytics.collector.metrics.JsonFactLogger;
import com.mulesoft.analytics.collector.metrics.LineFactLogger;
import com.mulesoft.analytics.collector.metrics.LongAverageCalculator;
import com.mulesoft.analytics.collector.metrics.LongMetricDuplicator;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.metrics.PayloadStatsMetricsCommonsProducer;
import com.mulesoft.analytics.collector.metrics.PingEndpointFilter;
import com.mulesoft.analytics.collector.metrics.RamlBasedEndpointNormalizer;
import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.EventPipelineInfo;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import com.mulesoft.analytics.collector.pipeline.IdentityMapper;
import com.mulesoft.analytics.collector.pipeline.ScheduledLimiterAndAggregator;
import com.mulesoft.analytics.collector.pipeline.ScheduledProducer;
import com.mulesoft.analytics.collector.pipeline.SynchronizedStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;

@Singleton
public class PipelineRegistry {
    @Inject
    private Configuration configuration;
    @Inject
    private MetricLogWriter logWriter;
    @Inject
    private MetricV2LogWriter metriclogWriterV2;
    @Inject
    private RawApiMetricLogWriter rawApiMetricLogWriter;
    @Inject
    private CustomMetricLogWriter customMetricLogWriter;
    private final Object pipelinesLock = new Object();
    @GuardedBy(value="pipelinesLock")
    private Map<String, EventPipelineInfo<InvocationContext>> inboundCommonPipelineInfoMap = new HashMap<String, EventPipelineInfo<InvocationContext>>();
    @GuardedBy(value="pipelinesLock")
    private Map<String, EventPipeline<InvocationContext>> inboundAuxPipelineMap = new HashMap<String, EventPipeline<InvocationContext>>();
    @GuardedBy(value="pipelinesLock")
    private Map<String, EventPipeline<InvocationContext>> outboundCommonPipelineMap = new HashMap<String, EventPipeline<InvocationContext>>();
    @GuardedBy(value="pipelinesLock")
    private Map<String, Map<String, EventPipeline<Fact>>> customPipelineMap = new HashMap<String, Map<String, EventPipeline<Fact>>>();
    @GuardedBy(value="pipelinesLock")
    private Map<String, EventPipeline<Void>> payloadStatsPipelineMap = new HashMap<String, EventPipeline<Void>>();
    private final Supplier<ExecutorService> executorSupplier = Suppliers.memoize((Supplier)new Supplier<ExecutorService>(){

        public ExecutorService get() {
            return new ThreadPoolExecutor(PipelineRegistry.this.configuration.getThreadPoolSize(), PipelineRegistry.this.configuration.getThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(PipelineRegistry.this.configuration.getPrebufferMaxSize()), new ThreadFactoryBuilder().setNameFormat("Pipeline-AsyncProcessor-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
    });
    private final Supplier<ScheduledExecutorService> scheduledExecSupplier = Suppliers.memoize((Supplier)new Supplier<ScheduledExecutorService>(){

        public ScheduledExecutorService get() {
            return Executors.newScheduledThreadPool(PipelineRegistry.this.configuration.getThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("Pipeline-Scheduled-%d").build());
        }
    });

    public <T> EventPipelineInfo<T> createInboundPipelineInfo(String appId, EventMapper<T, InvocationContext> notificationMapper) {
        return this.createInboundPipelineInfo(appId, notificationMapper, null);
    }

    public <T> EventPipelineInfo<T> createInboundPipelineInfo(String appId, EventMapper<T, InvocationContext> notificationMapper, @Nullable Supplier<List<String>> endpointTemplateSupplier) {
        EventPipelineInfo<InvocationContext> commonPipelineInfo = this.getCommonInboundPipelineInfo(appId, new LineFactLogger(Metrics.INBOUND_INVOCATION.getName(), this.logWriter), endpointTemplateSupplier);
        EventPipeline<Object> pipeline = this.configuration.getMuleMajorVersion() == 3 ? EventPipeline.startWith(notificationMapper).continueWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).endWith(commonPipelineInfo.getPipeline()) : EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).continueWith(notificationMapper).endWith(commonPipelineInfo.getPipeline());
        pipeline.start();
        return new EventPipelineInfo<Object>(pipeline, commonPipelineInfo.getCorrelator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventPipelineInfo<InvocationContext> getCommonInboundPipelineInfo(String appId, EventConsumer<Fact> invocationMetricLogger, @Nullable Supplier<List<String>> endpointTemplateSupplier) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipelineInfo<InvocationContext> pipelineInfo = this.inboundCommonPipelineInfoMap.get(appId);
            if (pipelineInfo == null) {
                FactCombiner factCombiner = new FactCombiner(this.configuration.getCombinerMaxSize());
                EventPipeline pipeline = EventPipeline.startWith(new SynchronizedStep()).continueWith(new InvocationContextToFactTransformer()).continueWith(factCombiner).continueWith(new PingEndpointFilter()).endWith(this.createInvocationMetricTail(appId, Metrics.INBOUND_INVOCATION, invocationMetricLogger, endpointTemplateSupplier));
                pipeline.start();
                pipelineInfo = new EventPipelineInfo(pipeline, factCombiner);
                this.inboundCommonPipelineInfoMap.put(appId, pipelineInfo);
            }
            return pipelineInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EventPipeline<InvocationContext> getAuxInboundPipeline(String appId) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipelineInfo<InvocationContext> commonPipelineInfo;
            EventPipeline<InvocationContext> pipeline = this.inboundAuxPipelineMap.get(appId);
            if (pipeline == null && (commonPipelineInfo = this.inboundCommonPipelineInfoMap.get(appId)) != null) {
                pipeline = EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).endWith(commonPipelineInfo.getPipeline());
                this.inboundAuxPipelineMap.put(appId, pipeline);
            }
            return pipeline;
        }
    }

    public <T> EventPipeline<T> createOutboundPipeline(String appId, EventMapper<T, InvocationContext> notificationMapper) {
        EventPipeline<InvocationContext> commonPipeline = this.getCommonOutboundPipeline(appId, new LineFactLogger(Metrics.OUTBOUND_INVOCATION.getName(), this.logWriter));
        EventPipeline<Object> pipeline = this.configuration.getMuleMajorVersion() == 3 ? EventPipeline.startWith(notificationMapper).continueWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).endWith(commonPipeline) : EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).continueWith(notificationMapper).endWith(commonPipeline);
        pipeline.start();
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventPipeline<InvocationContext> getCommonOutboundPipeline(String appId, EventConsumer<Fact> invocationMetricLogger) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<InvocationContext> pipeline = this.outboundCommonPipelineMap.get(appId);
            if (pipeline == null) {
                pipeline = EventPipeline.startWith(new SynchronizedStep()).continueWith(new InvocationContextToFactTransformer()).continueWith(new FactCombiner(this.configuration.getCombinerMaxSize())).endWith(this.createInvocationMetricTail(appId, Metrics.OUTBOUND_INVOCATION, invocationMetricLogger, null));
                pipeline.start();
                this.outboundCommonPipelineMap.put(appId, pipeline);
            }
            return pipeline;
        }
    }

    private EventMapper<Fact, Fact> createEndpointNormalizer(@Nullable Supplier<List<String>> endpointTemplateSupplier) {
        HeuristicEndpointNormalizer originalNormalizer = new HeuristicEndpointNormalizer("endpoint", this.configuration.getPreservedEndpointTokens());
        if (this.configuration.isRamlBasedEndpointNormalizationEnabled() && endpointTemplateSupplier != null) {
            return new RamlBasedEndpointNormalizer(endpointTemplateSupplier, originalNormalizer);
        }
        return originalNormalizer;
    }

    private EventPipeline<Fact> createInvocationMetricTail(String appId, FactMeta factMeta, EventConsumer<Fact> eventConsumer, @Nullable Supplier<List<String>> endpointTemplateSupplier) {
        EventPipeline<Fact> p = EventPipeline.startWith(this.createEndpointNormalizer(endpointTemplateSupplier)).continueWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), factMeta, 1).setSamplingSize(5).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).continueWith(new LongAverageCalculator("response_time", "avg_response_time")).continueWith(new LongMetricDuplicator("response_time.count", "avg_request_count")).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(eventConsumer);
        p.start();
        return p;
    }

    private EventPipeline<Fact> createApiMetricTail(JsonFactLogger rawMetricLogger, JsonFactLogger summaryMetricLogger, JsonFactLogger clientIpMetricLogger, JsonFactLogger pathMetricLogger, JsonFactLogger geohashMetricLogger) {
        ArrayList fantail = new ArrayList();
        fantail.add(this.createApiRawMetricTail(rawMetricLogger));
        fantail.add(this.createApiSummaryMetricTail(summaryMetricLogger));
        if (this.configuration.isApiClientIpMetricEnabled()) {
            fantail.add(this.createApiClientIpMetricTail(clientIpMetricLogger));
        }
        if (this.configuration.isApiPathMetricEnabled()) {
            fantail.add(this.createApiPathMetricTail(pathMetricLogger));
        }
        if (this.configuration.isApiGeohashMetricEnabled()) {
            fantail.add(this.createApiGeohashMetricTail(geohashMetricLogger));
        }
        EventPipeline<Fact> p = EventPipeline.startWith(new IdentityMapper()).fork(fantail);
        p.start();
        return p;
    }

    EventPipeline<Fact> createApiRawMetricTail(JsonFactLogger logger) {
        EventPipeline<Fact> p = EventPipeline.startWith(new EventMapper<Fact, Fact>(){

            @Override
            public Collection<Event<Fact>> process(Event<Fact> event) {
                if (PipelineRegistry.this.configuration.isRawApiMetricEnabled()) {
                    return Collections.singleton(event);
                }
                return Collections.emptyList();
            }
        }).endWith(logger);
        p.start();
        return p;
    }

    private EventPipeline<Fact> createApiSummaryMetricTail(JsonFactLogger logger) {
        EventPipeline<Fact> p = EventPipeline.startWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), Metrics.API_SUMMARY_METRIC, 5).setSamplingSize(5).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).endWith(logger);
        p.start();
        return p;
    }

    private EventPipeline<Fact> createApiClientIpMetricTail(JsonFactLogger logger) {
        EventPipeline<Fact> p = EventPipeline.startWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), Metrics.API_CLIENT_IP_METRIC, this.configuration.getApiMetricsClientIpSamplingSize()).setSamplingSize(this.configuration.getApiMetricsClientIpSamplingSize()).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).endWith(logger);
        p.start();
        return p;
    }

    private EventPipeline<Fact> createApiPathMetricTail(JsonFactLogger logger) {
        EventPipeline<Fact> p = EventPipeline.startWith(new HeuristicEndpointNormalizer("path", this.configuration.getPreservedEndpointTokens())).continueWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), Metrics.API_PATH_METRIC, this.configuration.getApiMetricsPathSamplingSize()).setSamplingSize(this.configuration.getApiMetricsPathSamplingSize()).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).endWith(logger);
        p.start();
        return p;
    }

    private EventPipeline<Fact> createApiGeohashMetricTail(JsonFactLogger logger) {
        EventPipeline<Fact> p = EventPipeline.startWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), Metrics.API_GEOHASH_METRIC, this.configuration.getApiMetricsGeohashSamplingSize()).setSamplingSize(this.configuration.getApiMetricsGeohashSamplingSize()).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).endWith(logger);
        p.start();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPipeline<Fact> getCustomMetricPipeline(String appId, String metricName, FactMeta metricMeta) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventConsumer<Fact> consumer;
            Map<String, EventPipeline<Fact>> appMap;
            if (this.configuration.shouldResetCustomMetricsPipeline()) {
                this.customPipelineMap.clear();
            }
            if ((appMap = this.customPipelineMap.get(appId)) == null) {
                appMap = new HashMap<String, EventPipeline<Fact>>();
                this.customPipelineMap.put(appId, appMap);
            }
            CustomMetricsCommonsProducer customCommonTags = new CustomMetricsCommonsProducer(this.configuration);
            EventPipeline<Fact> pipeline = appMap.get(metricName);
            EventConsumer<Fact> eventConsumer = consumer = this.configuration.getCustomMetricsFormat().equals("json") ? new JsonFactLogger(metricMeta, customCommonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), this.customMetricLogWriter, Metrics.BATCHER_SETTINGS_MAP) : new LineFactLogger(metricMeta.getName(), this.logWriter);
            if (pipeline == null) {
                pipeline = EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).continueWith(new ScheduledLimiterAndAggregator((ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), metricMeta, this.configuration.getAggregationTopN()).setOtherValue(this.configuration.getOtherValue())).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(consumer);
                pipeline.start();
                appMap.put(metricName, pipeline);
            }
            return pipeline;
        }
    }

    public <T> EventPipeline<T> createApiMetricsPipeline(EventMapper<T, Fact> initialMapper) {
        ApiMetricsCommonsProducer commonTags = new ApiMetricsCommonsProducer(this.configuration);
        AbstractLogWriter metricWriter = this.configuration.getDeploymentType() == DeploymentType.RTF ? this.logWriter : this.metriclogWriterV2;
        JsonFactLogger rawMetricLogger = new JsonFactLogger(Metrics.API_RAW_METRIC, commonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), this.rawApiMetricLogWriter, Metrics.BATCHER_SETTINGS_MAP);
        JsonFactLogger summaryMetricLogger = new JsonFactLogger(Metrics.API_SUMMARY_METRIC, commonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), metricWriter, Metrics.BATCHER_SETTINGS_MAP);
        JsonFactLogger clientIpMetricLogger = new JsonFactLogger(Metrics.API_CLIENT_IP_METRIC, commonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), metricWriter, Metrics.BATCHER_SETTINGS_MAP);
        JsonFactLogger pathMetricLogger = new JsonFactLogger(Metrics.API_PATH_METRIC, commonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), metricWriter, Metrics.BATCHER_SETTINGS_MAP);
        JsonFactLogger geohashMetricLogger = new JsonFactLogger(Metrics.API_GEOHASH_METRIC, commonTags, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAggregationTimeInterval(), metricWriter, Metrics.BATCHER_SETTINGS_MAP);
        EventPipeline pipeline = EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).continueWith(initialMapper).continueWith(new GeohashMapper(this.configuration)).endWith(this.createApiMetricTail(rawMetricLogger, summaryMetricLogger, clientIpMetricLogger, pathMetricLogger, geohashMetricLogger));
        pipeline.start();
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPayloadStatsMetricPipeline(String appId, EventProducer<Fact> payloadStatsCollector) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<Void> pipeline = this.payloadStatsPipelineMap.get(appId);
            if (pipeline == null) {
                pipeline = EventPipeline.startWith(new ScheduledProducer<Fact>(payloadStatsCollector, (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAbpMetricCollectionInterval(), this.configuration.getAbpMetricCollectionInterval(), true)).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(new JsonFactLogger(Metrics.PAYLOAD_STATS_METRIC, new PayloadStatsMetricsCommonsProducer(this.configuration), (ScheduledExecutorService)this.scheduledExecSupplier.get(), this.configuration.getAbpMetricCollectionInterval(), this.metriclogWriterV2, Metrics.BATCHER_SETTINGS_MAP, true));
                pipeline.start();
                this.payloadStatsPipelineMap.put(appId, pipeline);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPayloadStatsMetricPipelinePresent(String appId) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            return this.payloadStatsPipelineMap.get(appId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopPayloadStatsMetricPipeline(String appId) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<Void> payloadStatsPipeline = this.payloadStatsPipelineMap.remove(appId);
            if (payloadStatsPipeline != null) {
                payloadStatsPipeline.stop();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String appId) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<InvocationContext> inboundAuxPipeline;
            Map<String, EventPipeline<Fact>> customMetricPipelines;
            EventPipeline<InvocationContext> outboundPipeline;
            EventPipelineInfo<InvocationContext> inboundPipelineInfo = this.inboundCommonPipelineInfoMap.remove(appId);
            if (inboundPipelineInfo != null) {
                inboundPipelineInfo.getPipeline().stop();
            }
            if ((outboundPipeline = this.outboundCommonPipelineMap.remove(appId)) != null) {
                outboundPipeline.stop();
            }
            if ((customMetricPipelines = this.customPipelineMap.remove(appId)) != null) {
                for (EventPipeline<Fact> p : customMetricPipelines.values()) {
                    p.stop();
                }
            }
            if ((inboundAuxPipeline = this.inboundAuxPipelineMap.remove(appId)) != null) {
                inboundAuxPipeline.stop();
            }
        }
        this.stopPayloadStatsMetricPipeline(appId);
    }
}

