/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.mule.agent.MuleAgentSetup;
import com.mulesoft.dias.security.KeyManager;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.service.DefaultAuthenticationProxyClient;
import com.mulesoft.dias.util.MuleHomePath;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

public class DefaultAuthenticationProxyFactory {
    public static final String JKS = "JKS";
    public static final String MULE_AGENT_JKS = "mule-agent.jks";
    private static final String TRUSTSTORE_JKS = "truststore.jks";
    private static final String ALTERNATIVE_TRUSTSTORE_JKS = "anypoint-truststore.jks";

    public AuthenticationProxyClient create(String keyStorePassword, ObjectMapper objectMapper, URI endpoint, MuleAgentConfig muleAgentConfig) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException, KeyManagementException {
        KeyManager km = new KeyManager(JKS);
        km.init(MuleHomePath.getConfigPath(MULE_AGENT_JKS).toString(), keyStorePassword);
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        TrustManager[] trustManagers = muleAgentConfig.isOnPrem() ? this.getDummyTrustManager() : this.getTrustManagers();
        sslContext.init(km.getKeyManagers(), trustManagers, secureRandom);
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setSslContext(new JdkSslContext(sslContext, true, ClientAuth.REQUIRE));
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(builder.build());
        return new DefaultAuthenticationProxyClient(endpoint, client, objectMapper);
    }

    private TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        if (!MuleAgentSetup.isTrustStore()) {
            return null;
        }
        com.mulesoft.dias.security.TrustManager tm = new com.mulesoft.dias.security.TrustManager(JKS);
        tm.init(this.getKeystorePath().toString(), null);
        return tm.getTrustManagers();
    }

    private Path getKeystorePath() throws IOException {
        Path defaultPath = MuleHomePath.getConfigPath(TRUSTSTORE_JKS);
        if (Files.exists(defaultPath, new LinkOption[0])) {
            return defaultPath;
        }
        Path alternativePath = MuleHomePath.getConfigPath(ALTERNATIVE_TRUSTSTORE_JKS);
        if (Files.exists(alternativePath, new LinkOption[0])) {
            return alternativePath;
        }
        throw new IOException("truststore.jks or anypoint-truststore.jks not found.");
    }

    private TrustManager[] getDummyTrustManager() {
        return new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }
        }};
    }
}

