/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventBatchMapper;
import com.mulesoft.analytics.collector.pipeline.EventCorrelator;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class GroupByKeyReducer<I, O>
extends Step<I, O>
implements EventCorrelator {
    @Nullable
    protected EventBatchMapper<I, O> processor;
    private int maxSize;
    private LinkedHashMap<Object, List<Event<I>>> groupingCache;

    protected GroupByKeyReducer(int cacheMaxSize) {
        this.maxSize = cacheMaxSize;
        this.groupingCache = new LinkedHashMap();
    }

    public GroupByKeyReducer(int maxSize, @Nullable EventBatchMapper<I, O> processor) {
        this(maxSize);
        this.processor = processor;
    }

    @Override
    protected void process(Event<I> event) {
        if (this.processor == null) {
            return;
        }
        List<Event<I>> events = null;
        Object groupingKey = event.getGroupingKey();
        if (groupingKey != null) {
            events = this.groupingCache.get(groupingKey);
        }
        if (events == null) {
            events = new ArrayList<Event<I>>();
        }
        events.add(event);
        Collection<Event<O>> newEvents = this.processor.process(events);
        if (newEvents == null) {
            if (event.getGroupingKey() != null) {
                if (this.groupingCache.size() >= this.maxSize) {
                    Object firstEntry = this.groupingCache.keySet().iterator().next();
                    this.groupingCache.remove(firstEntry);
                }
                this.groupingCache.put(event.getGroupingKey(), events);
            }
        } else if (groupingKey != null) {
            this.groupingCache.remove(groupingKey);
            for (Event<O> newEvent : newEvents) {
                this.nextProcess(newEvent);
            }
        }
    }

    @Override
    public boolean containsEventWithGroupingKey(Object key) {
        return this.groupingCache.containsKey(key);
    }

    public void evictKey(@Nullable Object key) {
        this.groupingCache.remove(key);
    }
}

