/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.geohash.queries;

import com.mulesoft.analytics.collector.shaded.geohash.BoundingBox;
import com.mulesoft.analytics.collector.shaded.geohash.GeoHash;
import com.mulesoft.analytics.collector.shaded.geohash.WGS84Point;
import com.mulesoft.analytics.collector.shaded.geohash.queries.GeoHashQuery;
import com.mulesoft.analytics.collector.shaded.geohash.util.GeoHashSizeTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GeoHashBoundingBoxQuery
implements GeoHashQuery,
Serializable {
    private static final long serialVersionUID = 9223256928940522683L;
    private List<GeoHash> searchHashes = new ArrayList<GeoHash>(4);
    private BoundingBox boundingBox;

    public GeoHashBoundingBoxQuery(BoundingBox bbox) {
        int fittingBits = GeoHashSizeTable.numberOfBitsForOverlappingGeoHash(bbox);
        WGS84Point center = bbox.getCenterPoint();
        GeoHash centerHash = GeoHash.withBitPrecision(center.getLatitude(), center.getLongitude(), fittingBits);
        if (this.hashFits(centerHash, bbox)) {
            this.addSearchHash(centerHash);
        } else {
            this.expandSearch(centerHash, bbox);
        }
    }

    private void addSearchHash(GeoHash hash) {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox(hash.getBoundingBox());
        } else {
            this.boundingBox.expandToInclude(hash.getBoundingBox());
        }
        this.searchHashes.add(hash);
    }

    private void expandSearch(GeoHash centerHash, BoundingBox bbox) {
        this.addSearchHash(centerHash);
        for (GeoHash adjacent : centerHash.getAdjacent()) {
            BoundingBox adjacentBox = adjacent.getBoundingBox();
            if (!adjacentBox.intersects(bbox) || this.searchHashes.contains(adjacent)) continue;
            this.addSearchHash(adjacent);
        }
    }

    private boolean hashFits(GeoHash hash, BoundingBox bbox) {
        return hash.contains(bbox.getUpperLeft()) && hash.contains(bbox.getLowerRight());
    }

    @Override
    public boolean contains(GeoHash hash) {
        for (GeoHash searchHash : this.searchHashes) {
            if (!hash.within(searchHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(WGS84Point point) {
        return this.contains(GeoHash.withBitPrecision(point.getLatitude(), point.getLongitude(), 64));
    }

    @Override
    public List<GeoHash> getSearchHashes() {
        return this.searchHashes;
    }

    public String toString() {
        StringBuilder bui = new StringBuilder();
        for (GeoHash hash : this.searchHashes) {
            bui.append(hash).append("\n");
        }
        return bui.toString();
    }

    @Override
    public String getWktBox() {
        return "BOX(" + this.boundingBox.getMinLon() + " " + this.boundingBox.getMinLat() + "," + this.boundingBox.getMaxLon() + " " + this.boundingBox.getMaxLat() + ")";
    }
}

