/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.AdaptiveConfigImpl;

public class AdaptiveConfigBuilder {
    private AdaptiveConfigImpl adaptiveConfig = new AdaptiveConfigImpl();
    private boolean singleLowerBoundSet = false;
    private boolean singleUpperBoundSet = false;
    private boolean combinedLowerBoundSet = false;
    private boolean maximumNSet = false;

    AdaptiveConfigBuilder() {
    }

    public AdaptiveConfigBuilder setSingleEventLowerBound(double singleEventLowerBound) {
        this.singleLowerBoundSet = true;
        this.adaptiveConfig.setSingleEventLowerBound(singleEventLowerBound);
        return this;
    }

    public AdaptiveConfigBuilder setSingleEventUpperBound(double singleEventUpperBound) {
        this.singleUpperBoundSet = true;
        this.adaptiveConfig.setSingleEventUpperBound(singleEventUpperBound);
        return this;
    }

    public AdaptiveConfigBuilder setCombinedEventLowerBound(double combinedEventLowerBound) {
        this.combinedLowerBoundSet = true;
        this.adaptiveConfig.setCombinedEventLowerBound(combinedEventLowerBound);
        return this;
    }

    public AdaptiveConfigBuilder setPerDimMaximumN(int maximumN) {
        this.maximumNSet = true;
        this.adaptiveConfig.setPerDimMaximumN(maximumN);
        return this;
    }

    AdaptiveConfigImpl build(AdaptiveConfigImpl baseConfig) {
        if (baseConfig == null) {
            return new AdaptiveConfigImpl(this.adaptiveConfig);
        }
        AdaptiveConfigImpl result = new AdaptiveConfigImpl(baseConfig);
        return this.apply(result);
    }

    public AdaptiveConfigImpl apply(AdaptiveConfigImpl config) {
        if (this.singleLowerBoundSet) {
            config.setSingleEventLowerBound(this.adaptiveConfig.getSingleEventLowerBound());
        }
        if (this.singleUpperBoundSet) {
            config.setSingleEventUpperBound(this.adaptiveConfig.getSingleEventUpperBound());
        }
        if (this.combinedLowerBoundSet) {
            config.setCombinedEventLowerBound(this.adaptiveConfig.getCombinedEventLowerBound());
        }
        if (this.maximumNSet) {
            config.setPerDimMaximumN(this.adaptiveConfig.getPerDimMaximumN());
        }
        if (config.getSingleEventLowerBound() > config.getSingleEventUpperBound()) {
            throw new IllegalArgumentException("single event lower bound (" + config.getSingleEventLowerBound() + ") cannot be greater than single event upper bound (" + config.getSingleEventUpperBound() + ")");
        }
        if (config.getSingleEventLowerBound() > config.getCombinedEventLowerBound()) {
            throw new IllegalArgumentException("single event lower bound (" + config.getSingleEventLowerBound() + ") cannot be greater than combined event upper bound (" + config.getCombinedEventLowerBound() + ")");
        }
        return config;
    }
}

