/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.abp;

import com.mulesoft.analytics.collector.abp.MuleStatsProvider;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MuleStatsProducer
implements EventProducer<Fact> {
    private final MuleStatsProvider muleStatsProvider;
    private final String appId;
    private final Configuration config;
    private long statsStartTime = -1L;

    public MuleStatsProducer(MuleStatsProvider muleStatsProvider, String appId, Configuration config) {
        this.muleStatsProvider = muleStatsProvider;
        this.appId = appId;
        this.config = config;
    }

    @Override
    public Collection<Event<Fact>> produce() {
        if (!this.muleStatsProvider.isEnabled()) {
            return Collections.emptyList();
        }
        long newStatsStartTime = this.muleStatsProvider.getStatsStartTime();
        ArrayList<Event<Fact>> result = new ArrayList<Event<Fact>>();
        if (this.statsStartTime != newStatsStartTime) {
            if (this.statsStartTime != -1L) {
                this.config.resetAbpSessionId();
            }
            Fact fact = new Fact();
            fact.setDimension("app_id", this.appId);
            fact.setDimension("app_session", this.config.getAbpSessionId());
            fact.setLongMetric("message_count", 0L);
            fact.setLongMetric("error_count", 0L);
            result.add(new Event<Fact>(fact));
            this.statsStartTime = newStatsStartTime;
            return result;
        }
        long messageCount = this.muleStatsProvider.getMessageCount();
        long errorCount = this.muleStatsProvider.getErrorCount();
        if (messageCount != 0L || errorCount != 0L) {
            Fact fact = new Fact();
            fact.setDimension("app_id", this.appId);
            fact.setDimension("app_session", this.config.getAbpSessionId());
            fact.setLongMetric("message_count", messageCount);
            fact.setLongMetric("error_count", errorCount);
            result.add(new Event<Fact>(fact));
        }
        return result;
    }
}

