/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import java.util.HashMap;
import java.util.Map;

public enum StrategyType {
    NONE("none"),
    RANDOM_SAMPLING("random-sampling"),
    TOP_N_ONLY("top-n"),
    ADAPTIVE_TOP_N("adaptive-top-n");

    private String name;
    private static final Map<String, StrategyType> NAME_TO_STRATEGY;

    private StrategyType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static final StrategyType fromName(String name) {
        return NAME_TO_STRATEGY.get(name);
    }

    static {
        NAME_TO_STRATEGY = new HashMap<String, StrategyType>();
        for (StrategyType s : StrategyType.values()) {
            NAME_TO_STRATEGY.put(s.name, s);
        }
    }
}

