/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.util;

import com.google.common.base.Preconditions;

public class Strings {
    private Strings() {
    }

    public static String normalize(String name) {
        return name.replaceAll("[^a-zA-Z0-9_/\\.:-]", "_");
    }

    public static String toCamelCase(String underscoredString) {
        return Strings.fromUnderscoredString(underscoredString.toLowerCase());
    }

    private static String fromUnderscoredString(String underscoredString) {
        int action = 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < underscoredString.length(); ++i) {
            char c = underscoredString.charAt(i);
            if (c == '_') {
                action = 1;
                continue;
            }
            char val = action == -1 ? Character.toLowerCase(c) : (action == 1 ? Character.toUpperCase(c) : c);
            result.append(val);
            action = -1;
        }
        return result.toString();
    }

    public static String processInvocationId(String id) {
        Preconditions.checkNotNull((Object)id);
        if (id.length() > 36) {
            return id.substring(0, 36);
        }
        return id;
    }
}

