/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.EventAggregate;
import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.strategy.StrategyState;
import java.util.List;

public class NonAggregatedResult
implements EventLimiterResult {
    private UserEvent[] events;
    private EventProcessorConfig config;
    private StrategyState state;

    public NonAggregatedResult(List<UserEvent> eventList, EventProcessorConfig config, StrategyState strat) {
        this.config = config;
        this.state = strat;
        this.events = eventList == null ? null : eventList.toArray(new UserEvent[eventList.size()]);
    }

    @Override
    public boolean isLimited() {
        return this.config.getStrategy() == StrategyType.RANDOM_SAMPLING && this.state == StrategyState.APPLYING_LIMIT;
    }

    @Override
    public boolean isAggregated() {
        return false;
    }

    @Override
    public UserEvent[] getEventsNotAggregated() {
        return this.events;
    }

    @Override
    public EventAggregate[] getEventAggregates() {
        return null;
    }

    @Override
    public Object[] getRetainingValues() {
        return this.events.length > 0 && this.config.getRetainingDims().length > 0 ? this.events[0].getDimensionValues(this.config.getRetainingDims()) : null;
    }

    @Override
    public UserEvent getSampleEvent() {
        return this.events == null ? null : this.events[0];
    }
}

