/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import com.mulesoft.dias.configurator.AgentConfigurator;
import java.io.IOException;
import java.util.Properties;

public class InstallerMessages {
    public static final String MESSAGES_PROPERTIES = "messages.properties";
    private static Properties messages;

    public static void loadMessages() {
        try {
            messages = new Properties();
            messages.load(AgentConfigurator.class.getClassLoader().getResourceAsStream(MESSAGES_PROPERTIES));
        }
        catch (IOException e) {
            System.exit(1);
        }
    }

    public static String noMuleHomeProvidedMessage() {
        return InstallerMessages.formatMessage("mule.home.error");
    }

    public static String notProvidedMuleHome() {
        return InstallerMessages.formatMessage("mule.home.not.specified");
    }

    public static String agentConfigPropertyMissing() {
        return InstallerMessages.formatMessage("agent.config.property.missing");
    }

    public static String agentConfigSuccessfully() {
        return InstallerMessages.formatMessage("mule.agent.successfully.configured");
    }

    public static String unauthorized() {
        return InstallerMessages.formatMessage("https.unauthorized");
    }

    public static String proxyConfigMissing() {
        return InstallerMessages.formatMessage("agent.config.proxy.missing");
    }

    public static String invalidMuleLibPath() {
        return InstallerMessages.formatMessage("mule.lib.path.invalid");
    }

    public static String unexpectedError() {
        return InstallerMessages.formatMessage("unexpected.error");
    }

    private static String formatMessage(String key) {
        return messages.getProperty(key);
    }
}

