/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.module.autodiscovery.AutoDiscoveryMetadata;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.MuleContext;

@Singleton
public class ApiMetadataExtractor {
    static final Logger LOGGER = LogManager.getLogger(ApiMetadataExtractor.class);

    public Collection<String> getApiIds(MuleContext context) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Collection list;
            if (context != null && (list = context.getRegistry().lookupObjects(AutoDiscoveryMetadata.class)) != null) {
                for (AutoDiscoveryMetadata item : list) {
                    String version = item.getVersion();
                    int pos = version.lastIndexOf(":");
                    String apiId = pos >= 0 ? version.substring(pos + 1) : version;
                    result.add(apiId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot extract API Metadata", (Throwable)e);
        }
        return result;
    }
}

