/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DownloaderProxyClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class CountryDbDownloader {
    private static final Logger LOGGER = LogManager.getLogger(CountryDbDownloader.class);
    @Inject
    private Configuration configuration;
    @Inject
    private DownloaderProxyClient proxyClient;

    public void download() {
        block11: {
            try {
                String downloadUrl = this.configuration.getCountryDbDownloadUrl();
                String downloadFileChecksum = this.configuration.getCountryDbChecksum();
                if (downloadUrl == null || downloadFileChecksum == null || this.configuration.isCountryDbCurrent()) break block11;
                LOGGER.info("Downloading Country database");
                Path countryDbPath = this.configuration.getCountryDbPath();
                String zipFilename = StringUtils.substringAfterLast((String)downloadUrl, (String)"/");
                String zipTmpFilename = zipFilename + ".tmp";
                File zipTmpFile = countryDbPath.resolve(zipTmpFilename).toFile();
                boolean proxyConfigured = this.proxyClient.readProxyConfig();
                if (proxyConfigured) {
                    this.proxyClient.downloadToFile(downloadUrl, zipTmpFile);
                } else {
                    FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)zipTmpFile);
                }
                Thread.sleep(1000L);
                Hasher hasher = Hashing.md5().newHasher();
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(zipTmpFile));){
                    ByteStreams.copy((InputStream)gzipInputStream, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                }
                String hVal = hasher.hash().toString();
                LOGGER.info("Temp file hash value: " + hVal);
                if (downloadFileChecksum.equals(hVal)) {
                    LOGGER.info("Checksum matched. Enabling country lookup with database file {}.", (Object)zipFilename);
                    CountryDbDownloader.deleteExistingCountryDbFiles(this.configuration.getCountryDbPath());
                    FileUtils.moveFile((File)zipTmpFile, (File)countryDbPath.resolve(zipFilename).toFile());
                    this.configuration.resetApiCountryMetricPipeline();
                } else {
                    LOGGER.error("Checksum mismatch");
                    FileUtils.deleteQuietly((File)zipTmpFile);
                }
            }
            catch (Exception e) {
                LOGGER.error("Country database download failed", (Throwable)e);
            }
        }
    }

    static void deleteExistingCountryDbFiles(Path countryDbPath) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(countryDbPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return Configuration.LOCATION_DB_MATCHER.matches(entry);
            }
        });){
            for (Path filePath : stream) {
                Files.delete(filePath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete existing location database files", (Throwable)e);
        }
    }
}

