/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Collection;

@Immutable
public final class FactMeta {
    private final String name;
    private final ImmutableSet<String> retainingDimensions;
    private final ImmutableSet<String> collapsibleDimensions;
    private final ImmutableSet<String> longMetrics;
    private final ImmutableSet<String> doubleMetrics;

    private FactMeta(String name, Collection<String> retainingDimensions, Collection<String> collapsibleDimensions, Collection<String> longMetrics, Collection<String> doubleMetrics) {
        this.name = name;
        this.retainingDimensions = ImmutableSet.copyOf(retainingDimensions);
        this.collapsibleDimensions = ImmutableSet.copyOf(collapsibleDimensions);
        this.longMetrics = ImmutableSet.copyOf(longMetrics);
        this.doubleMetrics = ImmutableSet.copyOf(doubleMetrics);
    }

    public String getName() {
        return this.name;
    }

    public ImmutableSet<String> getRetainingDimensions() {
        return this.retainingDimensions;
    }

    public ImmutableSet<String> getCollapsibleDimensions() {
        return this.collapsibleDimensions;
    }

    public ImmutableSet<String> getLongMetrics() {
        return this.longMetrics;
    }

    public ImmutableSet<String> getDoubleMetrics() {
        return this.doubleMetrics;
    }

    public static class Builder {
        private String name;
        private Collection<String> retainingDimensions = new ArrayList<String>();
        private Collection<String> collapsibleDimensions = new ArrayList<String>();
        private Collection<String> longMetrics = new ArrayList<String>();
        private Collection<String> doubleMetrics = new ArrayList<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addRetainingDimension(String name) {
            this.retainingDimensions.add(name);
            return this;
        }

        public Builder addCollapsibleDimension(String name) {
            this.collapsibleDimensions.add(name);
            return this;
        }

        public Builder addLongMetric(String name) {
            this.longMetrics.add(name);
            return this;
        }

        public Builder addDoubleMetric(String name) {
            this.doubleMetrics.add(name);
            return this;
        }

        public FactMeta build() {
            return new FactMeta(this.name, this.retainingDimensions, this.collapsibleDimensions, this.longMetrics, this.doubleMetrics);
        }
    }
}

