/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.strategy.topn;

import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.AggregatedResult;
import com.mulesoft.analytics.limiter.data.UserEventAggregate;
import com.mulesoft.analytics.limiter.data.ValueVector;
import com.mulesoft.analytics.limiter.strategy.AbstractAggregationStrategy;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.StrategyState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TopNStrategy
extends AbstractAggregationStrategy
implements EventLimiterStrategy {
    public TopNStrategy(EventProcessorConfig config) {
        super(config);
    }

    @Override
    public StrategyType getType() {
        return StrategyType.TOP_N_ONLY;
    }

    @Override
    public void begin() {
        super.begin();
    }

    @Override
    public void append(UserEvent event) {
        if (this.currentState == StrategyState.FINISHED_COLLECTING) {
            throw new IllegalStateException("Cannot add more events. Strategy is in end() state.");
        }
        ValueVector v = this.getCollapsibleValues(event);
        UserEventAggregate e = (UserEventAggregate)this.eventAggregateByValue.get(v);
        if (e == null) {
            if (this.currentState == StrategyState.COLLECTING_SAMPLES) {
                e = new UserEventAggregate(event, v, this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
                e.addEvent(event);
                this.eventAggregateByValue.put(v, e);
            } else if (this.currentState == StrategyState.APPLYING_LIMIT) {
                if (this.otherEvent == null) {
                    this.otherEvent = new UserEventAggregate(event, this.getOtherValueVector(), this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
                    this.otherEvent.addEvent(event);
                } else {
                    this.otherEvent.addEvent(event);
                }
            }
        } else {
            e.addEvent(event);
        }
    }

    @Override
    public void learn() {
        this.currentState = StrategyState.APPLYING_LIMIT;
    }

    @Override
    public void end() {
        this.currentState = StrategyState.FINISHED_COLLECTING;
    }

    @Override
    public EventLimiterResult getResults() {
        int topN = this.config.getMaxOutput();
        this.numSamples = this.eventAggregateByValue.size();
        List<Map.Entry<ValueVector, UserEventAggregate>> topNList = this.getSortedEventList();
        ArrayList<UserEventAggregate> result = new ArrayList<UserEventAggregate>();
        UserEvent sample = topNList.isEmpty() ? null : topNList.get(0).getValue().getSampleEvent();
        for (int i = 0; i < topN; ++i) {
            if (topNList.size() <= i) {
                return new AggregatedResult(false, result, this.retainingDimensions);
            }
            result.add(topNList.get(i).getValue());
            this.numEvents += (double)topNList.get(i).getValue().getEventCount();
        }
        topNList = topNList.subList(this.config.getMaxOutput(), topNList.size());
        if (this.otherEvent == null) {
            this.otherEvent = new UserEventAggregate(sample, this.getOtherValueVector(), this.collapsibleDimensions, this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
        }
        for (Map.Entry<ValueVector, UserEventAggregate> e : topNList) {
            this.numEvents += (double)this.otherEvent.addEventCount(e.getValue().getEventCount());
        }
        result.add(this.otherEvent);
        return new AggregatedResult(true, result, this.retainingDimensions);
    }

    @Override
    public String getLearningInfo() {
        return null;
    }

    @Override
    public String getSamplingInfo() {
        return null;
    }

    @Override
    public String getOtherInfo() {
        return null;
    }
}

