/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.model.ApiMetrics;
import com.mulesoft.analytics.collector.config.model.MetricLog;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import com.mulesoft.analytics.collector.config.model.RuntimeId;
import com.mulesoft.analytics.collector.util.ResettableSupplier;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Configuration {
    public static final String VISUALIZER_PROPERTY_NAMESPACE = "anypoint.platform.visualizer.";
    public static final String VISUALIZER_PROPERTY_PREFIX = "viz.";
    public static final String BASE64_PROPERTY_PREFIX = "base64.";
    public static final String PROPERTY_CLOUDHUB_ORG_ID = "csorganization.id";
    public static final String PROPERTY_ENV_ID = "environment.id";
    public static final String PROPERTY_FLAG_ENABLE_AGENT = "anypoint.platform.config.analytics.agent.enabled";
    public static final String PROPERTY_FLAG_DISABLE_AGENT = "anypoint.platform.config.analytics.agent.disabled";
    public static final String PROPERTY_FLAG_DISABLE_HEADER_INJECTION = "anypoint.platform.config.analytics.agent.header_injection.disabled";
    public static final String PROPERTY_API_METRICS_LEVEL = "anypoint.platform.config.analytics.agent.api_metrics.level";
    public static final String PROPERTY_FLAG_ENABLE_API_CLIENT_IP_METRICS = "anypoint.platform.config.analytics.agent.api_metrics.client_ip.enabled";
    public static final String PROPERTY_API_METRICS_CLIENT_IP_SAMPLING_SIZE = "anypoint.platform.config.analytics.agent.api_metrics.client_ip.sampling_size";
    public static final String PROPERTY_FLAG_ENABLE_API_PATH_METRICS = "anypoint.platform.config.analytics.agent.api_metrics.path.enabled";
    public static final String PROPERTY_API_METRICS_PATH_SAMPLING_SIZE = "anypoint.platform.config.analytics.agent.api_metrics.path.sampling_size";
    public static final String PROPERTY_FLAG_ENABLE_API_GEOHASH_METRICS = "anypoint.platform.config.analytics.agent.api_metrics.geohash.enabled";
    public static final String PROPERTY_API_METRICS_GEOHASH_SAMPLING_SIZE = "anypoint.platform.config.analytics.agent.api_metrics.geohash.sampling_size";
    public static final String PROPERTY_FLAG_ENABLE_API_RAW_METRICS = "anypoint.platform.config.analytics.agent.api_raw_metrics.enabled";
    public static final String PROPERTY_FLAG_ENABLE_ABP_METRICS_ENABLED = "anypoint.platform.config.analytics.agent.abp_metrics.enabled";
    public static final String PROPERTY_FLAG_ENABLE_ABP_METRICS_FREQUENCY = "anypoint.platform.config.analytics.agent.abp_metrics.frequency";
    public static final String PROPERTY_AGENT_ORIGIN = "anypoint.platform.config.analytics.agent.origin";
    public static final String PROPERTY_PRESERVED_ENDPOINT_TOKENS = "anypoint.platform.config.analytics.agent.preserved_endpoint_tokens";
    public static final String PROPERTY_FLAG_ENABLE_RAML_BASED_ENDPOINT_NORMALIZATION = "anypoint.platform.config.analytics.agent.raml_based_endpoint_normalization.enabled";
    public static final String PROPERTY_HYBRID_ORG_ID = "__internal.organization.id";
    public static final String PROPERTY_HYBRID_SVR_ID = "__internal.server.id";
    public static final String HTTP_APP_WORKER_HEADER = "x-anypnt-app-worker";
    private static final String RTF_APP_NAME_ENV_VAR = "MULE_APP_NAME";
    private static final String RTF_NODE_NAME_ENV_VAR = "NODE_NAME";
    private static final String RTF_POD_NAME_ENV_VAR = "POD_NAME";
    private static final String RTF_RTF_ID_ENV_VAR = "RTF_ID";
    private static final String RTF_ORG_ID_ENV_VAR = "ORG_ID";
    private static final String RTF_MASTER_ORG_ID_ENV_VAR = "MASTER_ORG_ID";
    private static final String RTF_ENV_ID_ENV_VAR = "ENV_ID";
    private static final String RTF_IS_PRODUCTION_VAR = "IS_PRODUCTION";
    private static final String DEFAULT_CUSTOM_METRICS_FORMAT = "line";
    private static final Logger LOGGER = LogManager.getLogger(Configuration.class);
    private static final String WORKER_PREFIX = "worker-";
    public static final PathMatcher LOCATION_DB_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/Anypoint-Location_????????.zip");
    private final Supplier<Path> muleHomeSupplier = Suppliers.memoize((Supplier)new Supplier<Path>(){

        public Path get() {
            return Paths.get("" + System.getProperty("mule.home"), new String[0]);
        }
    });
    private final Supplier<Path> muleLogsPathSupplier = Suppliers.memoize((Supplier)new Supplier<Path>(){

        public Path get() {
            return Configuration.this.getMuleHome().resolve("logs");
        }
    });
    private final Supplier<Path> amConfigPathSupplier = new Supplier<Path>(){

        public Path get() {
            return Configuration.this.getMuleHome().resolve("am").resolve("config");
        }
    };
    private final Supplier<Path> geoDbPathSupplier = new Supplier<Path>(){

        public Path get() {
            Path geoDbPath = Configuration.this.getMuleHome().resolve(".mule").resolve(".am").resolve("geo");
            Configuration.forceMkdir(geoDbPath);
            return geoDbPath;
        }
    };
    private final Supplier<Path> muleAgentYmlPathSupplier = new Supplier<Path>(){

        public Path get() {
            return Configuration.this.getMuleHome().resolve("conf").resolve("mule-agent.yml");
        }
    };
    private volatile boolean isAgentStarted = false;
    private volatile boolean isRunning = false;
    public static final String DEFAULT_METRIC_FILE_NAME = "_metric.log";
    public static final String DEFAULT_METRIC_FILE_PATTERN = "_metric-%i.log";
    public static final String DEFAULT_CUSTOM_METRIC_FILE_NAME = "_custom_metric.log";
    public static final String DEFAULT_CUSTOM_METRIC_FILE_PATTERN = "_custom_metric-%i.log";
    public static final String DEFAULT_METRIC_V2_FILE_NAME = "_v2_metric.log";
    public static final String DEFAULT_METRIC_V2_FILE_PATTERN = "_v2_metric-%i.log";
    public static final String DEFAULT_RAW_API_METRIC_FILE_NAME = "_raw_api_metric.log";
    public static final String DEFAULT_RAW_API_METRIC_FILE_PATTERN = "_raw_api_metric-%i.log";
    private static final String DEFAULT_MAX_FILE_SIZE = "10 MB";
    private static final String DEFAULT_MAX_NUM_FILES = "10";
    private static final String RAW_API_METRICS_MAX_FILE_SIZE = "5 MB";
    private static final String CUSTOM_METRICS_MAX_FILE_SIZE = "2 MB";
    private static final int DEFAULT_API_METRICS_CLIENT_IP_SAMPLING_SIZE = 100;
    private static final int DEFAULT_API_METRICS_PATH_SAMPLING_SIZE = 100;
    private static final int DEFAULT_API_METRICS_GEOHASH_SAMPLING_SIZE = 200;
    @Nullable
    private MetricLog metricLog;
    @Nullable
    private MetricLog metricV2Log;
    @Nullable
    private MetricLog customMetricLog;
    @Nullable
    private MetricLog rawApiMetricLog;
    private final ResettableSupplier<Boolean> isPremiumTierSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return Configuration.this.runtimeConfig != null && Configuration.this.runtimeConfig.getHarvester() != null && (Integer)ObjectUtils.defaultIfNull((Object)Configuration.this.runtimeConfig.getHarvester().getProductTier(), (Object)0) >= 1;
        }
    });
    @Nullable
    private DeploymentType deploymentType;
    @Nullable
    private RuntimeConfig runtimeConfig;
    @Nullable
    private String orgId;
    @Nullable
    private String masterOrgId;
    @Nullable
    private String envId;
    @Nullable
    private String isProduction;
    @Nullable
    private String envType;
    @Nullable
    private String runtimeId;
    @Nullable
    private String clusterId;
    @Nullable
    private String serverName;
    @Nullable
    private String appId;
    @Nullable
    private String proxyUrl;
    private boolean isServerIdSet = false;
    @Nullable
    private String serverId;
    private boolean isPublicIPSet = false;
    @Nullable
    private String publicIP;
    private boolean isDeploymentHashSet = false;
    @Nullable
    private String deploymentHash;
    private final ResettableSupplier<Boolean> isHeaderInjectionEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            String val = System.getProperty(Configuration.PROPERTY_FLAG_DISABLE_HEADER_INJECTION);
            return !BooleanUtils.isTrue((Boolean)BooleanUtils.toBooleanObject((String)val));
        }
    });
    private final ResettableSupplier<ApiMetricsLevel> apiMetricsLevelSupplier = new ResettableSupplier<ApiMetricsLevel>(new Supplier<ApiMetricsLevel>(){

        public ApiMetricsLevel get() {
            ApiMetrics apiMetrics;
            String val = System.getProperty(Configuration.PROPERTY_API_METRICS_LEVEL);
            if (val == null && (apiMetrics = Configuration.this.getApiMetrics()) != null) {
                val = apiMetrics.getApiMetricsLevel();
            }
            return (ApiMetricsLevel)((Object)Enums.getIfPresent(ApiMetricsLevel.class, (String)Strings.nullToEmpty((String)val).toUpperCase()).or((Object)ApiMetricsLevel.ALL));
        }
    });
    private final ResettableSupplier<Boolean> isCustomMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return Configuration.this.isPremiumTier() || Configuration.this.isAgentOriginConfigured();
        }
    });
    private final ResettableSupplier<Boolean> isRawApiMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return Configuration.this.isPremiumTier() && (BooleanUtils.toBoolean((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_API_RAW_METRICS)) || Configuration.this.getRawApiMetricEnabled());
        }
    });
    private final ResettableSupplier<Boolean> isApiClientIpMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_API_CLIENT_IP_METRICS))) || Configuration.this.getApiClientIpMetricEnabled();
        }
    });
    private final ResettableSupplier<Integer> apiMetricsClientIpSamplingSizeSupplier = new ResettableSupplier<Integer>(new Supplier<Integer>(){

        public Integer get() {
            String val = System.getProperty(Configuration.PROPERTY_API_METRICS_CLIENT_IP_SAMPLING_SIZE);
            if (val != null) {
                return NumberUtils.toInt((String)val, (int)100);
            }
            ApiMetrics apiMetrics = Configuration.this.getApiMetrics();
            if (apiMetrics != null) {
                return (Integer)ObjectUtils.defaultIfNull((Object)apiMetrics.getClientIpSamplingSize(), (Object)100);
            }
            return 100;
        }
    });
    private final ResettableSupplier<Boolean> isApiPathMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_API_PATH_METRICS))) || Configuration.this.getApiPathMetricEnabled();
        }
    });
    private final ResettableSupplier<Integer> apiMetricsPathSamplingSizeSupplier = new ResettableSupplier<Integer>(new Supplier<Integer>(){

        public Integer get() {
            String val = System.getProperty(Configuration.PROPERTY_API_METRICS_PATH_SAMPLING_SIZE);
            if (val != null) {
                return NumberUtils.toInt((String)val, (int)100);
            }
            ApiMetrics apiMetrics = Configuration.this.getApiMetrics();
            if (apiMetrics != null) {
                return (Integer)ObjectUtils.defaultIfNull((Object)apiMetrics.getPathSamplingSize(), (Object)100);
            }
            return 100;
        }
    });
    private final ResettableSupplier<Boolean> isApiGeohashMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return (BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_API_GEOHASH_METRICS))) || Configuration.this.getApiGeohashMetricEnabled()) && Configuration.this.isGeoDbCurrent();
        }
    });
    private final ResettableSupplier<Integer> apiMetricsGeohashSamplingSizeSupplier = new ResettableSupplier<Integer>(new Supplier<Integer>(){

        public Integer get() {
            String val = System.getProperty(Configuration.PROPERTY_API_METRICS_GEOHASH_SAMPLING_SIZE);
            if (val != null) {
                return NumberUtils.toInt((String)val, (int)200);
            }
            ApiMetrics apiMetrics = Configuration.this.getApiMetrics();
            if (apiMetrics != null) {
                return (Integer)ObjectUtils.defaultIfNull((Object)apiMetrics.getGeohashSamplingSize(), (Object)200);
            }
            return 200;
        }
    });
    private final ResettableSupplier<Set<String>> preservedEndpointTokensSupplier = new ResettableSupplier<Set<String>>(new Supplier<Set<String>>(){

        public Set<String> get() {
            String val = Objects.toString(System.getProperty(Configuration.PROPERTY_PRESERVED_ENDPOINT_TOKENS), "");
            return ImmutableSet.copyOf((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)val));
        }
    });
    private final ResettableSupplier<Boolean> isRamlBasedEndpointNormalizationEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            return BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_RAML_BASED_ENDPOINT_NORMALIZATION)));
        }
    });
    private final ResettableSupplier<Boolean> isAbpMetricEnabledSupplier = new ResettableSupplier<Boolean>(new Supplier<Boolean>(){

        public Boolean get() {
            if (BooleanUtils.isTrue((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_ABP_METRICS_ENABLED)))) {
                return true;
            }
            return Configuration.this.runtimeConfig != null && Configuration.this.runtimeConfig.getAbpMetrics() != null && BooleanUtils.isTrue((Boolean)Configuration.this.runtimeConfig.getAbpMetrics().getEnabled()) && Configuration.this.getDeploymentType() == DeploymentType.CLOUDHUB;
        }
    });
    private final ResettableSupplier<Integer> abpMetricFrequencySupplier = new ResettableSupplier<Integer>(new Supplier<Integer>(){

        public Integer get() {
            String systemProp = System.getProperty(Configuration.PROPERTY_FLAG_ENABLE_ABP_METRICS_FREQUENCY);
            if (systemProp != null) {
                return NumberUtils.toInt((String)systemProp);
            }
            Integer frequency = Configuration.this.runtimeConfig != null && Configuration.this.runtimeConfig.getAbpMetrics() != null ? Configuration.this.runtimeConfig.getAbpMetrics().getFrequency() : null;
            return frequency != null ? frequency : 300000;
        }
    });
    private final ResettableSupplier<HashSet<String>> abpMetricWhitelistSupplier = new ResettableSupplier<HashSet<String>>(new Supplier<HashSet<String>>(){

        public HashSet<String> get() {
            List<String> list = Configuration.this.runtimeConfig != null && Configuration.this.runtimeConfig.getAbpMetrics() != null ? Configuration.this.runtimeConfig.getAbpMetrics().getWhitelist() : null;
            return new HashSet<String>((Collection)MoreObjects.firstNonNull(list, Collections.emptyList()));
        }
    });
    private final ResettableSupplier<HashSet<String>> abpMetricBlacklistSupplier = new ResettableSupplier<HashSet<String>>(new Supplier<HashSet<String>>(){

        public HashSet<String> get() {
            List<String> list = Configuration.this.runtimeConfig != null && Configuration.this.runtimeConfig.getAbpMetrics() != null ? Configuration.this.runtimeConfig.getAbpMetrics().getBlacklist() : null;
            return new HashSet<String>((Collection)MoreObjects.firstNonNull(list, Collections.emptyList()));
        }
    });
    private final Supplier<ScheduledExecutorService> scheduledExecSupplier = Suppliers.memoize((Supplier)new Supplier<ScheduledExecutorService>(){

        public ScheduledExecutorService get() {
            return Executors.newScheduledThreadPool(Configuration.this.getThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("Pipeline-Scheduled-%d").build());
        }
    });
    private final AtomicBoolean needApiMetricsPipelineReset = new AtomicBoolean();
    private final AtomicBoolean needCustomMetricsPipelineReset = new AtomicBoolean();
    private int muleMajorVersion;
    private final Map<String, Properties> appSpecificProperties = new HashMap<String, Properties>();
    private final Set<String> deployedApps = Sets.newConcurrentHashSet();

    @Nullable
    public DeploymentType getDeploymentType() {
        this.getOrgId();
        return this.deploymentType;
    }

    public void setRuntimeConfig(@Nullable RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void addAppSpecificProperties(String appName, @Nullable Properties properties) {
        if (properties != null) {
            Properties existingProps = this.appSpecificProperties.get(appName);
            if (existingProps == null) {
                existingProps = new Properties();
            }
            Properties merged = new Properties();
            merged.putAll((Map<?, ?>)existingProps);
            merged.putAll((Map<?, ?>)properties);
            this.appSpecificProperties.put(appName, merged);
        }
    }

    public void removeAppSpecificProperties(String appName) {
        this.appSpecificProperties.remove(appName);
    }

    @Nullable
    RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    @Nullable
    public String getOrgId() {
        if (this.orgId == null) {
            this.orgId = System.getProperty(PROPERTY_CLOUDHUB_ORG_ID);
            if (this.orgId != null) {
                this.deploymentType = DeploymentType.CLOUDHUB;
            } else {
                this.orgId = System.getProperty(PROPERTY_HYBRID_ORG_ID);
                if (this.orgId == null) {
                    RuntimeId id = this.getId();
                    String string = this.orgId = id != null ? id.getOrgId() : null;
                }
                if (this.orgId != null) {
                    this.deploymentType = DeploymentType.HYBRID;
                } else {
                    this.orgId = System.getenv(RTF_ORG_ID_ENV_VAR);
                    if (this.orgId != null) {
                        this.deploymentType = DeploymentType.RTF;
                    }
                }
            }
        }
        return this.orgId;
    }

    @Nullable
    String getMasterOrgId() {
        if (this.masterOrgId == null) {
            RuntimeId id;
            this.masterOrgId = System.getProperty("master.organization.id");
            if (this.masterOrgId == null && (id = this.getId()) != null) {
                this.masterOrgId = id.getMasterOrgId();
            }
            if (this.masterOrgId == null) {
                this.masterOrgId = System.getenv(RTF_MASTER_ORG_ID_ENV_VAR);
            }
        }
        return this.masterOrgId;
    }

    @Nullable
    public String getEnvId() {
        if (this.envId == null) {
            RuntimeId id;
            this.envId = System.getProperty(PROPERTY_ENV_ID);
            if (this.envId == null && (id = this.getId()) != null) {
                this.envId = id.getEnvId();
            }
            if (this.envId == null) {
                this.envId = System.getenv(RTF_ENV_ID_ENV_VAR);
            }
        }
        return this.envId;
    }

    @Nullable
    public String isProduction() {
        RuntimeId id;
        if (this.isProduction == null && (id = this.getId()) != null) {
            String string = this.isProduction = id.isProduction() != null ? id.isProduction().toString() : null;
        }
        if (this.isProduction == null) {
            this.isProduction = System.getenv(RTF_IS_PRODUCTION_VAR);
        }
        return this.isProduction == null || this.isProduction.equals("true") ? "t" : "f";
    }

    @Nullable
    String getEnvType() {
        if (this.envType == null) {
            RuntimeId id;
            this.envType = System.getProperty("environment.type");
            if (this.envType == null && (id = this.getId()) != null) {
                this.envType = id.getEnvType();
            }
        }
        return this.envType;
    }

    @Nullable
    public String getRuntimeId() {
        if (this.runtimeId == null) {
            RuntimeId id;
            String workerId;
            String rtId;
            String hybridServerName = System.getProperty(PROPERTY_HYBRID_SVR_ID);
            this.runtimeId = hybridServerName != null ? hybridServerName : ((rtId = System.getProperty("runtime.id")) != null ? rtId : ((workerId = System.getProperty("worker.id")) != null ? WORKER_PREFIX + workerId : ((id = this.getId()) != null && StringUtils.isNotEmpty((CharSequence)id.getRuntimeId()) ? id.getRuntimeId() : Configuration.readFirstLine(this.getAmConfigPath().resolve("server.id")))));
            if (this.runtimeId == null) {
                this.runtimeId = System.getenv(RTF_POD_NAME_ENV_VAR);
            }
        }
        return this.runtimeId;
    }

    @Nullable
    String getProxyUrl() {
        if (this.proxyUrl == null) {
            this.proxyUrl = Configuration.readFirstLine(this.getAmConfigPath().resolve("proxy.url"));
        }
        return this.proxyUrl;
    }

    @Nullable
    String getServerName() {
        if (this.serverName == null) {
            String name = System.getProperty("server.name");
            if (name != null) {
                this.serverName = name;
            } else {
                RuntimeId id = this.getId();
                if (id != null) {
                    this.serverName = id.getServerName();
                }
            }
        }
        return this.serverName;
    }

    @Nullable
    public String getClusterId() {
        if (this.clusterId == null) {
            String cid = System.getProperty("cluster.id");
            if (cid != null) {
                this.clusterId = cid;
            } else {
                RuntimeId id = this.getId();
                if (id != null && id.getClusterId() != null) {
                    this.clusterId = id.getClusterId();
                } else {
                    this.clusterId = System.getenv(RTF_RTF_ID_ENV_VAR);
                    if (this.clusterId == null) {
                        String val = System.getProperty("application.id");
                        this.clusterId = val != null ? val : this.getRuntimeId();
                    }
                }
            }
        }
        return this.clusterId;
    }

    @Nullable
    private RuntimeId getId() {
        return this.runtimeConfig != null ? this.runtimeConfig.getId() : null;
    }

    @Nullable
    private ApiMetrics getApiMetrics() {
        return this.runtimeConfig != null ? this.runtimeConfig.getApiMetrics() : null;
    }

    private boolean getRawApiMetricEnabled() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null && BooleanUtils.isTrue((Boolean)apiMetrics.getRawApiMetricEnabled());
    }

    private boolean getApiClientIpMetricEnabled() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null && BooleanUtils.isTrue((Boolean)apiMetrics.getClientIpMetricEnabled());
    }

    private boolean getApiPathMetricEnabled() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null && BooleanUtils.isTrue((Boolean)apiMetrics.getPathMetricEnabled());
    }

    private boolean getApiGeohashMetricEnabled() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null && BooleanUtils.isTrue((Boolean)apiMetrics.getGeohashMetricEnabled());
    }

    @Nullable
    public String getGeoDbDownloadUrl() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null ? apiMetrics.getGeoDbDownloadUrl() : null;
    }

    @Nullable
    public String getGeoDbChecksum() {
        ApiMetrics apiMetrics = this.getApiMetrics();
        return apiMetrics != null ? apiMetrics.getGeoDbChecksum() : null;
    }

    @Nullable
    public String getServerId() {
        if (!this.isServerIdSet) {
            this.isServerIdSet = true;
            this.serverId = System.getenv(RTF_NODE_NAME_ENV_VAR);
        }
        return this.serverId;
    }

    @Nullable
    public String getPublicIP() {
        if (!this.isPublicIPSet) {
            this.isPublicIPSet = true;
            this.publicIP = System.getProperty("worker.publicIP");
            if (this.publicIP == null) {
                try {
                    this.publicIP = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.publicIP = "unknown";
                }
            }
        }
        return this.publicIP;
    }

    @Nullable
    public String overrideAppId(@Nullable String originalAppId) {
        if (this.appId != null) {
            return this.appId;
        }
        if (System.getProperty(PROPERTY_CLOUDHUB_ORG_ID) != null) {
            this.appId = System.getProperty("fullDomain");
        }
        if (this.appId == null) {
            this.appId = System.getenv(RTF_APP_NAME_ENV_VAR);
        }
        return this.appId != null ? this.appId : originalAppId;
    }

    public boolean isEnabled() {
        String enabled = System.getProperty(PROPERTY_FLAG_ENABLE_AGENT);
        String disabled = System.getProperty(PROPERTY_FLAG_DISABLE_AGENT);
        if (enabled == null && disabled == null && this.getDeploymentType() == DeploymentType.CLOUDHUB) {
            return false;
        }
        if (enabled != null && !"true".equalsIgnoreCase(enabled) || "true".equalsIgnoreCase(disabled)) {
            return false;
        }
        return this.getOrgId() != null && this.getEnvId() != null && this.getRuntimeId() != null;
    }

    public int getPrebufferMaxSize() {
        if (this.runtimeConfig != null && this.runtimeConfig.getPrebufferMaxSize() != null) {
            return this.runtimeConfig.getPrebufferMaxSize();
        }
        return 10000;
    }

    public int getCombinerMaxSize() {
        if (this.runtimeConfig != null && this.runtimeConfig.getCombinerMaxSize() != null) {
            return this.runtimeConfig.getCombinerMaxSize();
        }
        return 1000;
    }

    public int getAggregationTimeInterval() {
        if (this.runtimeConfig != null && this.runtimeConfig.getAggregationTimeInterval() != null) {
            return this.runtimeConfig.getAggregationTimeInterval();
        }
        return 60000;
    }

    public int getAggregationTopN() {
        if (this.runtimeConfig != null && this.runtimeConfig.getAggregationTopN() != null) {
            return this.runtimeConfig.getAggregationTopN();
        }
        return 100;
    }

    public String getOtherValue() {
        if (this.runtimeConfig != null && this.runtimeConfig.getOtherValue() != null) {
            return this.runtimeConfig.getOtherValue();
        }
        return "other";
    }

    public Map<String, String> getVisualizerProperties(String appName) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.extractProperties(this.appSpecificProperties.get(appName), result);
        this.extractProperties(System.getProperties(), result);
        return result;
    }

    private void extractProperties(@Nullable Properties props, Map<String, String> result) {
        if (props != null) {
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                if (!propertyName.startsWith(VISUALIZER_PROPERTY_NAMESPACE) || propertyName.split(VISUALIZER_PROPERTY_NAMESPACE).length != 2) continue;
                result.put(VISUALIZER_PROPERTY_PREFIX + propertyName.split(VISUALIZER_PROPERTY_NAMESPACE)[1].toLowerCase(), props.getProperty(propertyName));
            }
        }
    }

    @Nullable
    public String generateWorkerHash(String appId) {
        String overrideAppId = this.overrideAppId(appId);
        String resolvedOrgId = this.getOrgId();
        String resolvedEnvId = this.getEnvId();
        String resolvedRuntimeId = this.getRuntimeId();
        if (resolvedOrgId != null && resolvedEnvId != null && resolvedRuntimeId != null && overrideAppId != null) {
            return this.generateHash("MD5", resolvedOrgId, resolvedEnvId, resolvedRuntimeId, overrideAppId);
        }
        return null;
    }

    @Nullable
    String generateHash(String algorithm, String ... elementsToHash) {
        try {
            MessageDigest instance = MessageDigest.getInstance(algorithm);
            for (String str : elementsToHash) {
                instance.update(str.getBytes());
            }
            return DatatypeConverter.printHexBinary((byte[])instance.digest());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to produce a hash", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String getDeploymentHash() {
        if (!this.isDeploymentHashSet) {
            this.isDeploymentHashSet = true;
            String applicationId = System.getProperty("application.id");
            String fileDigest = System.getProperty("application.file.content.digest");
            String propsDigest = System.getProperty("application.runtime.properties.digest");
            if (applicationId != null && fileDigest != null && propsDigest != null) {
                this.deploymentHash = this.generateHash("MD5", applicationId, fileDigest, propsDigest);
            }
        }
        return this.deploymentHash;
    }

    Path getAmConfigPath() {
        return (Path)this.amConfigPathSupplier.get();
    }

    private Path getMuleLogsPath() {
        return (Path)this.muleLogsPathSupplier.get();
    }

    public Path getMuleHome() {
        return (Path)this.muleHomeSupplier.get();
    }

    public String getMetricLogFileName() {
        return this.getSafePath(this.getMetricLog().getFileName(), DEFAULT_METRIC_FILE_NAME);
    }

    public String getMetricLogFilePattern() {
        return this.getSafePath(this.getMetricLog().getFilePattern(), DEFAULT_METRIC_FILE_PATTERN);
    }

    public String getMetricLogFileSize() {
        return this.getMetricLog().getFileSize();
    }

    public String getMetricLogMaxFiles() {
        return this.getMetricLog().getMaxFiles();
    }

    public String getMetricV2LogFileName() {
        return this.getSafePath(this.getMetricV2Log().getFileName(), DEFAULT_METRIC_V2_FILE_NAME);
    }

    public String getMetricV2LogFilePattern() {
        return this.getSafePath(this.getMetricV2Log().getFilePattern(), DEFAULT_METRIC_V2_FILE_PATTERN);
    }

    public String getMetricV2LogFileSize() {
        return this.getMetricV2Log().getFileSize();
    }

    public String getMetricV2LogMaxFiles() {
        return this.getMetricV2Log().getMaxFiles();
    }

    public String getCustomMetricLogFileName() {
        return this.getSafePath(this.getCustomMetricLog().getFileName(), DEFAULT_CUSTOM_METRIC_FILE_NAME);
    }

    public String getCustomMetricLogFilePattern() {
        return this.getSafePath(this.getCustomMetricLog().getFilePattern(), DEFAULT_CUSTOM_METRIC_FILE_PATTERN);
    }

    public String getCustomMetricsFormat() {
        String format = DEFAULT_CUSTOM_METRICS_FORMAT;
        if (this.runtimeConfig != null && this.runtimeConfig.getCustomMetricsFormat() != null) {
            format = this.runtimeConfig.getCustomMetricsFormat();
        }
        return format;
    }

    private boolean isAgentOriginConfigured() {
        return StringUtils.isNotBlank((CharSequence)System.getProperty(PROPERTY_AGENT_ORIGIN));
    }

    public boolean shouldLogJsonCustomMetrics() {
        return this.getCustomMetricsFormat().equals("json") || this.isAgentOriginConfigured();
    }

    public String getCustomMetricLogFileSize() {
        return this.getCustomMetricLog().getFileSize();
    }

    public String getCustomMetricLogMaxFiles() {
        return this.getCustomMetricLog().getMaxFiles();
    }

    public String getRawApiMetricLogFileName() {
        return this.getSafePath(this.getRawApiMetricLog().getFileName(), DEFAULT_RAW_API_METRIC_FILE_NAME);
    }

    public String getRawApiMetricLogFilePattern() {
        return this.getSafePath(this.getRawApiMetricLog().getFilePattern(), DEFAULT_RAW_API_METRIC_FILE_PATTERN);
    }

    public String getRawApiMetricLogFileSize() {
        return this.getRawApiMetricLog().getFileSize();
    }

    public String getRawApiMetricLogMaxFiles() {
        return this.getRawApiMetricLog().getMaxFiles();
    }

    public MetricLog getMetricLog() {
        if (this.metricLog == null) {
            this.metricLog = this.runtimeConfig != null && this.runtimeConfig.getMetricLog() != null ? this.runtimeConfig.getMetricLog() : new MetricLog(DEFAULT_METRIC_FILE_NAME, DEFAULT_METRIC_FILE_PATTERN, DEFAULT_MAX_FILE_SIZE, DEFAULT_MAX_NUM_FILES);
        }
        return this.metricLog;
    }

    public MetricLog getMetricV2Log() {
        if (this.metricV2Log == null) {
            this.metricV2Log = this.runtimeConfig != null && this.runtimeConfig.getMetricV2Log() != null ? this.runtimeConfig.getMetricV2Log() : new MetricLog(DEFAULT_METRIC_V2_FILE_NAME, DEFAULT_METRIC_V2_FILE_PATTERN, DEFAULT_MAX_FILE_SIZE, DEFAULT_MAX_NUM_FILES);
        }
        return this.metricV2Log;
    }

    public MetricLog getCustomMetricLog() {
        if (this.customMetricLog == null) {
            this.customMetricLog = this.runtimeConfig != null && this.runtimeConfig.getCustomMetricLog() != null ? this.runtimeConfig.getCustomMetricLog() : new MetricLog(DEFAULT_CUSTOM_METRIC_FILE_NAME, DEFAULT_CUSTOM_METRIC_FILE_PATTERN, CUSTOM_METRICS_MAX_FILE_SIZE, DEFAULT_MAX_NUM_FILES);
        }
        return this.customMetricLog;
    }

    public MetricLog getRawApiMetricLog() {
        if (this.rawApiMetricLog == null) {
            ApiMetrics apiMetrics = this.getApiMetrics();
            this.rawApiMetricLog = apiMetrics != null && apiMetrics.getRawApiMetricLog() != null ? apiMetrics.getRawApiMetricLog() : new MetricLog(DEFAULT_RAW_API_METRIC_FILE_NAME, DEFAULT_RAW_API_METRIC_FILE_PATTERN, RAW_API_METRICS_MAX_FILE_SIZE, DEFAULT_MAX_NUM_FILES);
        }
        return this.rawApiMetricLog;
    }

    private String getSafePath(String configuredValue, String defaultValue) {
        Path path = this.getMuleLogsPath().resolve(configuredValue).normalize();
        if (path.startsWith(this.getMuleLogsPath())) {
            return path.toString();
        }
        LOGGER.warn("Illegal configured value: " + configuredValue);
        return this.getMuleLogsPath().resolve(defaultValue).toString();
    }

    public boolean isHeaderInjectionEnabled() {
        return this.isHeaderInjectionEnabledSupplier.get();
    }

    public boolean isHeaderInjectionPropertySet() {
        return System.getProperty(PROPERTY_FLAG_DISABLE_HEADER_INJECTION) != null;
    }

    public ApiMetricsLevel getApiMetricsLevel() {
        return this.apiMetricsLevelSupplier.get();
    }

    public boolean isRawApiMetricEnabled() {
        return this.isRawApiMetricEnabledSupplier.get();
    }

    public boolean isCustomMetricEnabled() {
        return this.isCustomMetricEnabledSupplier.get();
    }

    public boolean isApiGeohashMetricEnabled() {
        return this.isApiGeohashMetricEnabledSupplier.get();
    }

    public Path getGeoDbPath() {
        return (Path)this.geoDbPathSupplier.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getExistingGeoDbFilename() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getGeoDbPath(), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return LOCATION_DB_MATCHER.matches(entry);
            }
        });){
            Iterator<Path> iterator = stream.iterator();
            if (!iterator.hasNext()) return null;
            String string = iterator.next().getFileName().toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read geo directory", (Throwable)e);
        }
        return null;
    }

    public boolean isGeoDbCurrent() {
        String existingGeoDbFilename = this.getExistingGeoDbFilename();
        if (existingGeoDbFilename != null) {
            String downloadUrl = this.getGeoDbDownloadUrl();
            if (downloadUrl == null) {
                return true;
            }
            return StringUtils.substringBeforeLast((String)existingGeoDbFilename, (String)".").equals(StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)downloadUrl, (String)"/"), (String)"."));
        }
        return false;
    }

    public Path getMuleAgentYmlPath() {
        return (Path)this.muleAgentYmlPathSupplier.get();
    }

    public boolean isApiClientIpMetricEnabled() {
        return this.isApiClientIpMetricEnabledSupplier.get();
    }

    public int getApiMetricsClientIpSamplingSize() {
        return this.apiMetricsClientIpSamplingSizeSupplier.get();
    }

    public boolean isApiPathMetricEnabled() {
        return this.isApiPathMetricEnabledSupplier.get();
    }

    public int getApiMetricsPathSamplingSize() {
        return this.apiMetricsPathSamplingSizeSupplier.get();
    }

    public int getApiMetricsGeohashSamplingSize() {
        return this.apiMetricsGeohashSamplingSizeSupplier.get();
    }

    public String getCollectorName() {
        return this.getClass().getPackage().getImplementationTitle();
    }

    public String getCollectorVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public Set<String> getPreservedEndpointTokens() {
        return this.preservedEndpointTokensSupplier.get();
    }

    public boolean isRamlBasedEndpointNormalizationEnabled() {
        return this.isRamlBasedEndpointNormalizationEnabledSupplier.get();
    }

    public boolean isAbpMetricEnabled() {
        return this.isAbpMetricEnabledSupplier.get();
    }

    public int getAbpMetricCollectionInterval() {
        return this.abpMetricFrequencySupplier.get();
    }

    public HashSet<String> getAbpMetricWhitelist() {
        return this.abpMetricWhitelistSupplier.get();
    }

    public HashSet<String> getAbpMetricBlacklist() {
        return this.abpMetricBlacklistSupplier.get();
    }

    public Supplier<ScheduledExecutorService> getScheduledExecutorService() {
        return this.scheduledExecSupplier;
    }

    public void logConfiguration() {
        LOGGER.info("Mode: {}", (Object)this.getDeploymentType());
        LOGGER.info("Premium tier: {}", (Object)this.isPremiumTier());
        LOGGER.info("Producer Name: {}", (Object)this.getCollectorName());
        LOGGER.info("Producer Version: {}", (Object)this.getCollectorVersion());
        LOGGER.info("Prebuffer max size: {}", (Object)this.getPrebufferMaxSize());
        LOGGER.info("Combiner max size: {}", (Object)this.getCombinerMaxSize());
        LOGGER.info("Aggregation time interval: {} ms", (Object)this.getAggregationTimeInterval());
        LOGGER.info("Aggregation Top N: {}", (Object)this.getAggregationTopN());
        LOGGER.info("Metric log file name: {} pattern: {} max size: {} max files: {}", (Object)this.getMetricLogFileName(), (Object)this.getMetricLogFilePattern(), (Object)this.getMetricLogFileSize(), (Object)this.getMetricLogMaxFiles());
        LOGGER.info("Metric V2 log file name: {} pattern: {} max size: {} max files: {}", (Object)this.getMetricV2LogFileName(), (Object)this.getMetricV2LogFilePattern(), (Object)this.getMetricV2LogFileSize(), (Object)this.getMetricV2LogMaxFiles());
        LOGGER.info("Raw API Metric log file name: {} pattern: {} max size: {} max files: {}", (Object)this.getRawApiMetricLogFileName(), (Object)this.getRawApiMetricLogFilePattern(), (Object)this.getRawApiMetricLogFileSize(), (Object)this.getRawApiMetricLogMaxFiles());
        if (this.muleMajorVersion == 3) {
            LOGGER.info("Header Injection Enabled: {}", (Object)this.isHeaderInjectionEnabled());
        }
        LOGGER.info("API Metrics Level: {}", (Object)this.getApiMetricsLevel());
        LOGGER.info("Raw API Metrics Enabled: {}", (Object)this.isRawApiMetricEnabled());
        LOGGER.info("Thread Pool Size: {}", (Object)this.getThreadPoolSize());
        LOGGER.info("Preserved Endpoint Tokens: {}", this.getPreservedEndpointTokens());
        LOGGER.info("RAML-based Endpoint Normalization Enabled: {}", (Object)this.isRamlBasedEndpointNormalizationEnabled());
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        if (this.isRunning && !isRunning) {
            this.reset();
        }
        this.isRunning = isRunning;
    }

    void reset() {
        LOGGER.debug("Reset");
        this.runtimeConfig = null;
        this.isHeaderInjectionEnabledSupplier.reset();
        this.apiMetricsLevelSupplier.reset();
        this.isRawApiMetricEnabledSupplier.reset();
        this.isCustomMetricEnabledSupplier.reset();
        this.isPremiumTierSupplier.reset();
        this.isApiClientIpMetricEnabledSupplier.reset();
        this.apiMetricsClientIpSamplingSizeSupplier.reset();
        this.isApiPathMetricEnabledSupplier.reset();
        this.apiMetricsPathSamplingSizeSupplier.reset();
        this.isApiGeohashMetricEnabledSupplier.reset();
        this.apiMetricsGeohashSamplingSizeSupplier.reset();
        this.needApiMetricsPipelineReset.set(true);
        this.needCustomMetricsPipelineReset.set(true);
        this.preservedEndpointTokensSupplier.reset();
        this.isRamlBasedEndpointNormalizationEnabledSupplier.reset();
        this.isAbpMetricEnabledSupplier.reset();
        this.abpMetricFrequencySupplier.reset();
        this.abpMetricWhitelistSupplier.reset();
        this.abpMetricBlacklistSupplier.reset();
    }

    public boolean shouldResetCustomMetricsPipeline() {
        return this.needCustomMetricsPipelineReset.compareAndSet(true, false);
    }

    public void resetApiGeohashMetricPipeline() {
        this.isApiGeohashMetricEnabledSupplier.reset();
        this.needApiMetricsPipelineReset.set(true);
    }

    public boolean shouldResetApiMetricsPipeline() {
        return this.needApiMetricsPipelineReset.compareAndSet(true, false);
    }

    public boolean isAgentStarted() {
        return this.isAgentStarted;
    }

    public void setAgentStarted(boolean agentStarted) {
        this.isAgentStarted = agentStarted;
    }

    @Nullable
    private static String readFirstLine(Path path) {
        if (path.toFile().exists()) {
            try {
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                if (!lines.isEmpty()) {
                    return lines.get(0);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read file: " + path, (Throwable)e);
            }
        }
        return null;
    }

    static void forceMkdir(Path path) {
        try {
            FileUtils.forceMkdir((File)path.toFile());
        }
        catch (Exception e) {
            LOGGER.error("Could not ensure directory " + path, (Throwable)e);
        }
    }

    public int getMuleMajorVersion() {
        return this.muleMajorVersion;
    }

    public void setMuleMajorVersion(int muleMajorVersion) {
        this.muleMajorVersion = muleMajorVersion;
    }

    public void setAppDeployed(String appId) {
        this.deployedApps.add(this.overrideAppId(appId));
    }

    public void setAppUndeployed(String appId) {
        this.deployedApps.remove(this.overrideAppId(appId));
    }

    public boolean isAppDeployed(String appId) {
        return this.deployedApps.contains(this.overrideAppId(appId));
    }

    public boolean isPremiumTier() {
        return this.isPremiumTierSupplier.get();
    }

    public int getThreadPoolSize() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
    }

    public static enum ApiMetricsLevel {
        NONE,
        BLOCKED,
        FAILED,
        ALL;

    }
}

