/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.geo.GeohashLookup;
import com.mulesoft.analytics.collector.geo.GeohashLookupImpl;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeohashMapper
implements EventMapper<Fact, Fact> {
    private static final Logger LOGGER = LogManager.getLogger(GeohashMapper.class);
    private final Configuration configuration;
    @Nullable
    private final GeohashLookup geohashLookup;

    public GeohashMapper(Configuration configuration) {
        this.configuration = configuration;
        this.geohashLookup = this.initGeohashLookup();
    }

    GeohashMapper(Configuration configuration, @Nullable GeohashLookup geohashLookup) {
        this.configuration = configuration;
        this.geohashLookup = geohashLookup;
    }

    @Nullable
    private GeohashLookup initGeohashLookup() {
        try {
            Path geoDbPath = this.configuration.getGeoDbPath();
            String geoDbFilename = this.configuration.getExistingGeoDbFilename();
            if (geoDbFilename == null) {
                LOGGER.info("Location database not found. Geohash lookup disabled.");
                return null;
            }
            return new GeohashLookupImpl(geoDbPath.resolve(geoDbFilename).toFile());
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize geohash lookup. Geohash lookup disabled.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact;
        String clientIp;
        if (this.geohashLookup != null && this.configuration.isApiGeohashMetricEnabled() && (clientIp = (fact = event.getValue()).getDimension("remote_host")) != null) {
            fact.setDimension("geohash", this.geohashLookup.geohash(clientIp));
        }
        return Collections.singleton(event);
    }
}

