/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.processor;

import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.adaptive.AdaptiveStrategy;
import com.mulesoft.analytics.limiter.strategy.none.KeepAllStrategy;
import com.mulesoft.analytics.limiter.strategy.sampling.SamplingStrategy;
import com.mulesoft.analytics.limiter.strategy.topn.TopNStrategy;

public class StrategyBuilder {
    public static EventLimiterStrategy getStrategy(EventProcessorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("No configuration provided to build a strategy.");
        }
        switch (config.getStrategy()) {
            case NONE: {
                return new KeepAllStrategy(config);
            }
            case RANDOM_SAMPLING: {
                return new SamplingStrategy(config);
            }
            case TOP_N_ONLY: {
                return new TopNStrategy(config);
            }
            case ADAPTIVE_TOP_N: {
                return new AdaptiveStrategy(config);
            }
        }
        throw new IllegalArgumentException("Strategy type " + (Object)((Object)config.getStrategy()) + " is not supported.");
    }
}

