/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent.unified;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mulesoft.dias.ex.AgentConfiguratorException;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.mule.agent.version.MuleAgentVersion;
import com.mulesoft.dias.mule.agent.version.MuleVersion;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.FileUtils;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class AgentInstaller {
    private static final String SERVER_ID_FILE = "server.id";
    private static final String REGISTRY_FILE = "registry";
    private static final String SOURCE_JSON_KEY = "source";
    private static final String OFFSET_JSON_KEY = "offset";
    private static final String TMP_EXTENSION = ".tmp";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String WRAPPER_CONF_FILE = "wrapper.conf";

    public void copyAgentJar() throws IOException {
        MuleAgentVersion muleVersion = MuleVersion.version();
        File muleDirectory = muleVersion.getUnifiedAgentPath().toFile();
        if (!muleDirectory.exists()) {
            FileUtils.createDir(muleDirectory);
        }
        this.deleteOldVersions(muleDirectory);
        this.copyCurrentVersion(muleVersion);
    }

    public void writeServerId() throws IOException {
        Path serverIdPath = MuleHomePath.getAMConfigPath(SERVER_ID_FILE);
        if (!Files.exists(serverIdPath, new LinkOption[0])) {
            String serverIdFromCert = this.getServerIdFromCert();
            Files.write(serverIdPath, serverIdFromCert.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        }
    }

    public void writeToWrapperConfFile() throws IOException {
        Path wrapperConfFilePath = MuleHomePath.getConfigPath(WRAPPER_CONF_FILE);
        String multipleConsumerEnabledProp = "-Danypoint.platform.analytics_multiple_consumers_enabled=true";
        String analyticsEnabledProp = "-Danypoint.platform.analytics_enabled=false";
        String multipleConsumerEnabledPropSerialized = "wrapper.java.additional.1053=" + multipleConsumerEnabledProp;
        String analyticsEnabledPropSerialized = "=-Danypoint.platform.analytics_enabled=true";
        String analyticsOnPremEnabled = "-Danypoint.platform.on_prem=true";
        String analyticsBaseUri = "-Danypoint.platform.analytics_base_uri";
        boolean onPremEnabled = false;
        boolean isFileModified = false;
        if (Files.exists(wrapperConfFilePath, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(wrapperConfFilePath, StandardCharsets.UTF_8);
            boolean multipleConsumerEnabledPropExists = false;
            for (int i = 0; i < lines.size(); ++i) {
                String tempString = lines.get(i);
                if (tempString.contains(multipleConsumerEnabledProp) && !tempString.startsWith("#")) {
                    multipleConsumerEnabledPropExists = true;
                }
                if (tempString.contains(analyticsEnabledProp) && !tempString.startsWith("#")) {
                    String sequenceNum = tempString.split("=")[0];
                    lines.set(i, sequenceNum + analyticsEnabledPropSerialized);
                    isFileModified = true;
                    ConsoleLogger.info("Configuration anypoint.platform.analytics_enabled set to true in wrapper.conf.");
                }
                if (!tempString.contains(analyticsOnPremEnabled) || tempString.startsWith("#")) continue;
                onPremEnabled = true;
            }
            if (!multipleConsumerEnabledPropExists) {
                lines.add("");
                lines.add("# Added by Anypoint Monitoring Installer");
                lines.add(multipleConsumerEnabledPropSerialized);
                isFileModified = true;
                ConsoleLogger.info("Configuration anypoint.platform.analytics_multiple_consumers_enabled=true added to wrapper.conf");
            }
            if (onPremEnabled) {
                boolean isBaseUriPresent = false;
                for (int i = 0; i < lines.size(); ++i) {
                    String[] array;
                    String tempString = lines.get(i);
                    if (!tempString.contains(analyticsBaseUri) || tempString.startsWith("#") || (array = tempString.split("=")).length < 2) continue;
                    isBaseUriPresent = true;
                    if (array.length < 3) continue;
                    lines.set(i, array[0] + "=" + array[1] + "=");
                    isFileModified = true;
                    ConsoleLogger.info("Configuration anypoint.platform.analytics_base_uri value removed in wrapper.conf");
                }
                if (!isBaseUriPresent) {
                    ConsoleLogger.warn("Configuration anypoint.platform.analytics_base_uri not present in wrapper.conf");
                }
            }
            if (isFileModified) {
                Path wrapperConfFileTmpPath = wrapperConfFilePath.getParent().resolve("wrapper.conf.tmp");
                Files.write(wrapperConfFileTmpPath, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                FileUtils.tryAtomicMove(wrapperConfFileTmpPath, wrapperConfFilePath);
            }
        }
    }

    private void copyCurrentVersion(MuleAgentVersion version) throws IOException {
        Files.copy(version.getAgentAMFile().toPath(), version.getLibTarget(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteOldVersions(File muleDirectory) {
        FileUtils.deleteAgentFiles(muleDirectory, "analytics-metrics-collector-mule.*.jar");
        FileUtils.deleteAgentFiles(muleDirectory, "mule-agent-dias.*.jar");
    }

    private String getServerIdFromCert() throws IOException {
        String agentConfig = new String(Files.readAllBytes(MuleHomePath.getConfigPath("mule-agent.yml")));
        MuleAgentConfig muleAgent = new MuleAgentConfig(agentConfig);
        String keyStorePassword = muleAgent.getKeyStorePassword();
        if (keyStorePassword != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(MuleHomePath.getConfigPath("mule-agent.jks").toFile()), keyStorePassword.toCharArray());
                Enumeration<String> es = keyStore.aliases();
                while (es.hasMoreElements()) {
                    Certificate certificate;
                    String alias = es.nextElement();
                    if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                    String dn = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                    LdapName ldapDn = new LdapName(dn);
                    for (Rdn rdn : ldapDn.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                        return rdn.getValue().toString();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new AgentConfiguratorException("Could not get server id from certificate");
    }

    public void adjustFilebeatRegistry() {
        this.adjustFilebeatRegistryFile(MuleHomePath.getLinuxServiceFilebeatDataPath(REGISTRY_FILE));
        this.adjustFilebeatRegistryFile(MuleHomePath.getFilebeatDataPath(REGISTRY_FILE));
    }

    private void adjustFilebeatRegistryFile(Path filebeatRegistryPath) {
        if (filebeatRegistryPath == null) {
            return;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(filebeatRegistryPath.toFile());
            if (rootNode.isArray()) {
                boolean modified = false;
                for (JsonNode logFileNode : rootNode) {
                    String logFile = logFileNode.path(SOURCE_JSON_KEY).asText();
                    long offset = logFileNode.path(OFFSET_JSON_KEY).asLong();
                    long fileSize = new File(logFile).length();
                    if (fileSize <= 0L || offset == fileSize) continue;
                    ((ObjectNode)logFileNode).put(OFFSET_JSON_KEY, fileSize);
                    modified = true;
                }
                if (modified) {
                    Path filebeatRegistryBakPath = filebeatRegistryPath.getParent().resolve("registry.bak");
                    FileUtils.tryAtomicMove(filebeatRegistryPath, filebeatRegistryBakPath);
                    Path filebeatRegistryTmpPath = filebeatRegistryPath.getParent().resolve("registry.tmp");
                    mapper.writer().writeValue(filebeatRegistryTmpPath.toFile(), (Object)rootNode);
                    FileUtils.tryAtomicMove(filebeatRegistryTmpPath, filebeatRegistryPath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

