/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CryptoServiceConstraintsException;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CryptoServiceProperties;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import com.mulesoft.analytics.collector.shaded.bouncycastle.internal.asn1.isara.IsaraObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.asymmetric.mlkem.MLKEMKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.BouncyCastleProvider;
import com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.bike.BIKEKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.cmce.CMCEKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.dilithium.DilithiumKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.falcon.FalconKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.hqc.HQCKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.kyber.KyberKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.ntru.NTRUKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.sphincsplus.SPHINCSPlusKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 * Exception performing whole class analysis ignored.
 */
public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final Logger LOG = Logger.getLogger(BouncyCastleProvider.class.getName());
    private static String info = "BouncyCastle Security Provider v1.80";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, (String)"java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final CryptoServiceProperties[] SYMMETRIC_CIPHERS = new CryptoServiceProperties[]{BouncyCastleProvider.service((String)"AES", (int)256), BouncyCastleProvider.service((String)"ARC4", (int)20), BouncyCastleProvider.service((String)"ARIA", (int)256), BouncyCastleProvider.service((String)"Blowfish", (int)128), BouncyCastleProvider.service((String)"Camellia", (int)256), BouncyCastleProvider.service((String)"CAST5", (int)128), BouncyCastleProvider.service((String)"CAST6", (int)256), BouncyCastleProvider.service((String)"ChaCha", (int)128), BouncyCastleProvider.service((String)"DES", (int)56), BouncyCastleProvider.service((String)"DESede", (int)112), BouncyCastleProvider.service((String)"GOST28147", (int)128), BouncyCastleProvider.service((String)"Grainv1", (int)128), BouncyCastleProvider.service((String)"Grain128", (int)128), BouncyCastleProvider.service((String)"HC128", (int)128), BouncyCastleProvider.service((String)"HC256", (int)256), BouncyCastleProvider.service((String)"IDEA", (int)128), BouncyCastleProvider.service((String)"Noekeon", (int)128), BouncyCastleProvider.service((String)"RC2", (int)128), BouncyCastleProvider.service((String)"RC5", (int)128), BouncyCastleProvider.service((String)"RC6", (int)256), BouncyCastleProvider.service((String)"Rijndael", (int)256), BouncyCastleProvider.service((String)"Salsa20", (int)128), BouncyCastleProvider.service((String)"SEED", (int)128), BouncyCastleProvider.service((String)"Serpent", (int)256), BouncyCastleProvider.service((String)"Shacal2", (int)128), BouncyCastleProvider.service((String)"Skipjack", (int)80), BouncyCastleProvider.service((String)"SM4", (int)128), BouncyCastleProvider.service((String)"TEA", (int)128), BouncyCastleProvider.service((String)"Twofish", (int)256), BouncyCastleProvider.service((String)"Threefish", (int)128), BouncyCastleProvider.service((String)"VMPC", (int)128), BouncyCastleProvider.service((String)"VMPCKSA3", (int)128), BouncyCastleProvider.service((String)"XTEA", (int)128), BouncyCastleProvider.service((String)"XSalsa20", (int)128), BouncyCastleProvider.service((String)"OpenSSLPBKDF", (int)128), BouncyCastleProvider.service((String)"DSTU7624", (int)256), BouncyCastleProvider.service((String)"GOST3412_2015", (int)256), BouncyCastleProvider.service((String)"Zuc", (int)128)};
    private static final String ASYMMETRIC_PACKAGE = "com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL", "CompositeSignatures"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "SPHINCSPlus", "Dilithium", "Falcon", "NTRU", "CONTEXT", "SLHDSA", "MLDSA", "MLKEM"};
    private static final String DIGEST_PACKAGE = "com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String KEYSTORE_PACKAGE = "com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};
    private Map<String, Provider.Service> serviceMap = new ConcurrentHashMap();

    public BouncyCastleProvider() {
        super("BC", 1.8, info);
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setup() {
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.digest.", DIGESTS);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_GENERIC);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_MACS);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_CIPHERS);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_GENERIC);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.keystore.", KEYSTORES);
        this.loadAlgorithms("com.mulesoft.analytics.collector.shaded.bouncycastle.jcajce.provider.drbg.", SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put((Object)"X509Store.CERTIFICATE/COLLECTION", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/COLLECTION", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put((Object)"X509Store.CRL/COLLECTION", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put((Object)"X509Store.CERTIFICATEPAIR/COLLECTION", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put((Object)"X509Store.CERTIFICATE/LDAP", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put((Object)"X509Store.CRL/LDAP", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/LDAP", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put((Object)"X509Store.CERTIFICATEPAIR/LDAP", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put((Object)"X509StreamParser.CERTIFICATE", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509CertParser");
        this.put((Object)"X509StreamParser.ATTRIBUTECERTIFICATE", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509AttrCertParser");
        this.put((Object)"X509StreamParser.CRL", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509CRLParser");
        this.put((Object)"X509StreamParser.CERTIFICATEPAIR", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509CertPairParser");
        this.put((Object)"Cipher.BROKENPBEWITHMD5ANDDES", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put((Object)"Cipher.BROKENPBEWITHSHA1ANDDES", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put((Object)"Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put((Object)"CertPathValidator.PKIX", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.PKIX", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put((Object)"CertStore.Collection", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put((Object)"CertStore.LDAP", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put((Object)"CertStore.Multi", (Object)"com.mulesoft.analytics.collector.shaded.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put((Object)"Alg.Alias.CertStore.X509LDAP", (Object)"LDAP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase(string2);
        String string4 = string + "." + string3;
        Provider.Service service = (Provider.Service)this.serviceMap.get(string4);
        if (service == null) {
            BouncyCastleProvider bouncyCastleProvider = this;
            synchronized (bouncyCastleProvider) {
                service = !this.serviceMap.containsKey(string4) ? (Provider.Service)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */) : (Provider.Service)this.serviceMap.get(string4);
            }
        }
        return service;
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            this.loadServiceClass(string, stringArray[i]);
        }
    }

    private void loadAlgorithms(String string, CryptoServiceProperties[] cryptoServicePropertiesArray) {
        for (int i = 0; i != cryptoServicePropertiesArray.length; ++i) {
            CryptoServiceProperties cryptoServiceProperties = cryptoServicePropertiesArray[i];
            try {
                CryptoServicesRegistrar.checkConstraints(cryptoServiceProperties);
                this.loadServiceClass(string, cryptoServiceProperties.getServiceName());
                continue;
            }
            catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("service for " + cryptoServiceProperties.getServiceName() + " ignored due to constraints");
            }
        }
    }

    private void loadServiceClass(String string, String string2) {
        Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, (String)(string + string2 + "$Mappings"));
        if (clazz != null) {
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure((ConfigurableProvider)this);
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + string2 + "$Mappings : " + String.valueOf(exception));
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(new ASN1ObjectIdentifier("1.3.9999.6.4.10"), (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, (AsymmetricKeyInfoConverter)new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, (AsymmetricKeyInfoConverter)new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, (AsymmetricKeyInfoConverter)new LMSKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.picnic_key, (AsymmetricKeyInfoConverter)new PicnicKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_512, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_1024, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(NISTObjectIdentifiers.id_alg_ml_kem_512, (AsymmetricKeyInfoConverter)new MLKEMKeyFactorySpi());
        this.addKeyInfoConverter(NISTObjectIdentifiers.id_alg_ml_kem_768, (AsymmetricKeyInfoConverter)new MLKEMKeyFactorySpi());
        this.addKeyInfoConverter(NISTObjectIdentifiers.id_alg_ml_kem_1024, (AsymmetricKeyInfoConverter)new MLKEMKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece348864_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece460896_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6688128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6960119_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece8192128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike128, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike192, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike256, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc128, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc192, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc256, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048509, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048677, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps4096821, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhrss701, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey((Object)(string + "." + string2)) || this.containsKey((Object)("Alg.Alias." + string + "." + string2));
    }

    public void addAlgorithm(String string, String string2) {
        if (this.containsKey((Object)string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put((Object)string, (Object)string2);
    }

    public void addAlgorithm(String string, String string2, Map<String, String> map) {
        this.addAlgorithm(string, string2);
        this.addAttributes(string, map);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + String.valueOf(aSN1ObjectIdentifier), string2);
        this.addAlgorithm(string + ".OID." + String.valueOf(aSN1ObjectIdentifier), string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map) {
        this.addAlgorithm(string, aSN1ObjectIdentifier, string2);
        this.addAttributes(string + "." + String.valueOf(aSN1ObjectIdentifier), map);
        this.addAttributes(string + ".OID." + String.valueOf(aSN1ObjectIdentifier), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    public void addAttributes(String string, Map<String, String> map) {
        this.put((Object)(string + " ImplementedIn"), (Object)"Software");
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey((Object)string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put((Object)string3, (Object)map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().on(BCObjectIdentifiers.picnic_key)) {
            return new PicnicKeyFactorySpi().generatePublic(subjectPublicKeyInfo);
        }
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    private static CryptoServiceProperties service(String string, int n) {
        return new JcaCryptoService(string, n);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.setup();
    }

    static /* synthetic */ Provider.Service access$101(BouncyCastleProvider bouncyCastleProvider, String string, String string2) {
        return super.getService(string, string2);
    }

    static /* synthetic */ Map access$200(BouncyCastleProvider bouncyCastleProvider) {
        return bouncyCastleProvider.serviceMap;
    }

    static /* synthetic */ Object access$301(BouncyCastleProvider bouncyCastleProvider, Object object) {
        return super.remove(object);
    }

    static /* synthetic */ void access$401(BouncyCastleProvider bouncyCastleProvider, Provider.Service service) {
        super.putService(service);
    }
}

