/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec;

import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECConstants;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECCurve;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECFieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECLookupTable;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECMultiplier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECPoint;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.WTauNafMultiplier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecT571K1Point;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat576;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT571K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT571K1_AFFINE_ZS = new ECFieldElement[]{new SecT571FieldElement(ECConstants.ONE)};
    protected SecT571K1Point infinity = new SecT571K1Point((ECCurve)this, null, null);

    public SecT571K1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decodeStrict("020000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT571K1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT571K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        long[] lArray = new long[n2 * 9 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat576.copy64((long[])((SecT571FieldElement)eCPoint.getRawXCoord()).x, (int)0, (long[])lArray, (int)n3);
            Nat576.copy64((long[])((SecT571FieldElement)eCPoint.getRawYCoord()).x, (int)0, (long[])lArray, (int)(n3 += 9));
            n3 += 9;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECT571K1_AFFINE_ZS;
    }
}

