/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.strategy.adaptive;

import com.mulesoft.analytics.limiter.AdaptiveConfig;
import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.AggregatedResult;
import com.mulesoft.analytics.limiter.data.OtherValue;
import com.mulesoft.analytics.limiter.data.UserEventAggregate;
import com.mulesoft.analytics.limiter.data.ValueVector;
import com.mulesoft.analytics.limiter.strategy.AbstractAggregationStrategy;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.StrategyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdaptiveStrategy
extends AbstractAggregationStrategy
implements EventLimiterStrategy {
    private Map<ValueVector, UserEventAggregate> topEventAggregateByValue;
    private Map<NamePath, Set<Object>> topDDimensionValueMap;
    private final Map<NamePath, AdaptiveConfig> perDimConfigMap = new HashMap<NamePath, AdaptiveConfig>();

    public AdaptiveStrategy(EventProcessorConfig config) {
        super(config);
        for (NamePath dimName : this.collapsibleDimensions) {
            AdaptiveConfig perDimConfig = config.getPerDimAdaptiveConfig().get(dimName);
            if (perDimConfig == null) {
                perDimConfig = config.getAdaptiveConfig();
            }
            this.perDimConfigMap.put(dimName, perDimConfig);
        }
    }

    @Override
    public StrategyType getType() {
        return StrategyType.ADAPTIVE_TOP_N;
    }

    @Override
    public void begin() {
        super.begin();
        this.currentState = StrategyState.COLLECTING_SAMPLES;
        this.topEventAggregateByValue = new LinkedHashMap<ValueVector, UserEventAggregate>();
        this.eventAggregateByValue = new LinkedHashMap();
    }

    @Override
    public void append(UserEvent event) {
        if (this.currentState == null || this.currentState == StrategyState.FINISHED_COLLECTING) {
            throw new IllegalStateException("Cannot add more events. Strategy is in end() state.");
        }
        this.numEvents += 1.0;
        ValueVector v = this.getCollapsibleValues(event);
        UserEventAggregate e = (UserEventAggregate)this.eventAggregateByValue.get(v);
        if (e == null && this.currentState == StrategyState.COLLECTING_SAMPLES) {
            e = new UserEventAggregate(event, v, this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
            e.addEvent(event);
            this.eventAggregateByValue.put(v, e);
        } else if (e == null && this.currentState == StrategyState.APPLYING_LIMIT) {
            v = this.getSampledValueVector(event);
            e = this.topEventAggregateByValue.get(v);
            if (e == null) {
                e = new UserEventAggregate(event, v, this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
                e.addEvent(event);
                this.topEventAggregateByValue.put(v, e);
            } else {
                e.addEvent(event);
            }
        } else if (e != null) {
            e.addEvent(event);
        }
    }

    @Override
    public void learn() {
        this.sampleCollapsableDimensions();
        this.createSampledEventBucket();
        this.currentState = StrategyState.APPLYING_LIMIT;
    }

    private void sampleCollapsableDimensions() {
        Map<NamePath, Map<Object, Integer>> dimValMap = this.getCollapsedDimensionValuesMap();
        this.topDDimensionValueMap = new LinkedHashMap<NamePath, Set<Object>>();
        for (Map.Entry<NamePath, Map<Object, Integer>> dimKeyToVal : dimValMap.entrySet()) {
            NamePath key = dimKeyToVal.getKey();
            AdaptiveConfig adaptiveConfig = this.perDimConfigMap.get(key);
            ArrayList<Map.Entry<Object, Integer>> sortedDimValsToCounts = new ArrayList<Map.Entry<Object, Integer>>(dimKeyToVal.getValue().entrySet());
            Collections.sort(sortedDimValsToCounts, new Comparator<Map.Entry<Object, Integer>>(){

                @Override
                public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            Set<Object> dimValues = this.getDimValueSet(key);
            double topCount = 0.0;
            int startPos = 0;
            for (int i = 0; i < adaptiveConfig.getPerDimMaximumN() && sortedDimValsToCounts.size() > i; ++i) {
                double dimValueCount = ((Integer)((Map.Entry)sortedDimValsToCounts.get(i)).getValue()).intValue();
                topCount += dimValueCount;
                if (dimValueCount / this.numEvents > adaptiveConfig.getSingleEventUpperBound()) {
                    startPos = i + 1;
                    dimValues.add(((Map.Entry)sortedDimValsToCounts.get(i)).getKey());
                }
                if (!(topCount / this.numEvents > adaptiveConfig.getCombinedEventLowerBound())) continue;
                for (int j = startPos; j <= i; ++j) {
                    if (!((double)((Integer)((Map.Entry)sortedDimValsToCounts.get(i)).getValue()).intValue() / this.numEvents > adaptiveConfig.getSingleEventLowerBound())) continue;
                    dimValues.add(((Map.Entry)sortedDimValsToCounts.get(j)).getKey());
                }
                startPos = i;
            }
            this.topDDimensionValueMap.put(key, dimValues);
        }
    }

    private Map<NamePath, Map<Object, Integer>> getCollapsedDimensionValuesMap() {
        LinkedHashMap<NamePath, Map<Object, Integer>> resultDimensionMap = new LinkedHashMap<NamePath, Map<Object, Integer>>();
        for (UserEventAggregate currEvent : this.eventAggregateByValue.values()) {
            NamePath[] dims = currEvent.getCollapsibleDimensions();
            Object[] vals = currEvent.getCollapsibleValues();
            for (int i = 0; i < dims.length; ++i) {
                Integer dimCount;
                LinkedHashMap<Object, Integer> dimValToCount = (LinkedHashMap<Object, Integer>)resultDimensionMap.get(dims[i]);
                if (dimValToCount == null) {
                    dimValToCount = new LinkedHashMap<Object, Integer>();
                    resultDimensionMap.put(dims[i], dimValToCount);
                }
                if ((dimCount = (Integer)dimValToCount.get(vals[i])) == null) {
                    dimCount = new Integer(0);
                }
                dimCount = dimCount + currEvent.getEventCount();
                dimValToCount.put(vals[i], dimCount);
            }
        }
        return resultDimensionMap;
    }

    private void createSampledEventBucket() {
        this.topEventAggregateByValue = new LinkedHashMap<ValueVector, UserEventAggregate>();
        for (Map.Entry entry : this.eventAggregateByValue.entrySet()) {
            ValueVector v = this.getSampledValueVector(((UserEventAggregate)entry.getValue()).getSampleEvent());
            UserEventAggregate topSampledEvent = this.topEventAggregateByValue.get(v);
            if (topSampledEvent != null) continue;
            topSampledEvent = new UserEventAggregate(((UserEventAggregate)entry.getValue()).getSampleEvent(), v, this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
            this.topEventAggregateByValue.put(v, topSampledEvent);
        }
    }

    protected ValueVector getSampledValueVector(UserEvent inputEvent) {
        Object[] collapsedDimVals = new Object[this.config.getCollapsibleDims().length];
        int index = 0;
        for (Map.Entry<NamePath, Set<Object>> dimToDimVal : this.topDDimensionValueMap.entrySet()) {
            Object dimValue = inputEvent.getDimensionValue(dimToDimVal.getKey());
            collapsedDimVals[index] = !dimToDimVal.getValue().contains(dimValue) ? OtherValue.OTHER : dimValue;
            ++index;
        }
        return new ValueVector(collapsedDimVals);
    }

    private Set<Object> getDimValueSet(NamePath collapsableDimension) {
        Set<Object> returnSet = this.topDDimensionValueMap.get(collapsableDimension);
        if (returnSet == null) {
            returnSet = new LinkedHashSet<Object>();
            this.topDDimensionValueMap.put(collapsableDimension, returnSet);
        }
        return returnSet;
    }

    @Override
    public void end() {
        if (this.currentState != StrategyState.APPLYING_LIMIT) {
            this.learn();
        }
    }

    @Override
    public EventLimiterResult getResults() {
        int i;
        boolean applyingLimit = false;
        this.numSamples = this.eventAggregateByValue.size();
        ArrayList<UserEventAggregate> result = new ArrayList<UserEventAggregate>();
        LinkedHashSet<ValueVector> toRemove = new LinkedHashSet<ValueVector>();
        int topN = this.config.getMaxOutput();
        for (Map.Entry<ValueVector, UserEventAggregate> e : this.topEventAggregateByValue.entrySet()) {
            if (e.getValue().getValueVector().hasOtherValue()) continue;
            UserEventAggregate val = (UserEventAggregate)this.eventAggregateByValue.remove(e.getKey());
            result.add(val != null ? val : e.getValue());
            toRemove.add(e.getKey());
        }
        for (ValueVector v : toRemove) {
            this.topEventAggregateByValue.remove(v);
        }
        List<Map.Entry<ValueVector, UserEventAggregate>> topNList = this.getSortedEventList();
        for (i = 0; i < topNList.size() && result.size() < topN; ++i) {
            result.add(topNList.get(i).getValue());
        }
        while (i < topNList.size()) {
            Map.Entry<ValueVector, UserEventAggregate> e = topNList.get(i);
            ValueVector v = this.getSampledValueVector(e.getValue().getSampleEvent());
            UserEventAggregate ue = this.topEventAggregateByValue.get(v);
            if (ue != null) {
                ue.mergeAggregate(e.getValue());
            }
            ++i;
        }
        for (Map.Entry<ValueVector, UserEventAggregate> e : this.topEventAggregateByValue.entrySet()) {
            UserEventAggregate fullVals = (UserEventAggregate)this.eventAggregateByValue.get(e.getKey());
            if (fullVals != null || e.getValue().getEventCount() == 0) continue;
            applyingLimit = true;
            result.add(e.getValue());
        }
        return new AggregatedResult(applyingLimit, result, this.retainingDimensions);
    }

    @Override
    public String getLearningInfo() {
        return null;
    }

    @Override
    public String getSamplingInfo() {
        return null;
    }

    @Override
    public String getOtherInfo() {
        return this.getOtherValueVector().toString();
    }
}

