/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.ApiMetadataExtractor;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CorePricingStatsProviderImpl;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.MuleStatsProviderImpl;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.agent.RamlBasedEndpointTemplateSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.Registry;
import org.mule.config.MuleManifest;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.module.launcher.AbstractDeploymentListener;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.application.Application;
import org.mule.registry.MuleRegistryHelper;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    @Inject
    protected List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Inject
    protected AppStatsHandler appStatsHandler;
    @Inject
    protected ApiMetadataExtractor apiMetadataExtractor;
    @Nullable
    private DeploymentService deploymentService;
    @Nullable
    private DeploymentListener deploymentListener;
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();
    private final Object notificationListenersLock = new Object();

    public void start() {
        if (this.deploymentService == null) {
            LOGGER.error("DeploymentService not set");
            return;
        }
        this.startCollector(3);
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
    }

    @Override
    protected void onCollectorPreStart() {
        this.registerAbpMetricsCollectorsForAllApps();
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    @Override
    @Nullable
    protected Properties getAgentAppProps(String overrideAppId) {
        if (this.agentApplicationPropertiesService != null) {
            return this.agentApplicationPropertiesService.getPropertiesForApplication(overrideAppId);
        }
        return null;
    }

    public void setDeploymentService(@Nullable DeploymentService deploymentService) {
        if (this.deploymentService != deploymentService) {
            this.deploymentService = deploymentService;
            if (this.deploymentListener == null) {
                this.deploymentListener = new CollectorDeploymentListener();
            }
            if (this.deploymentService != null) {
                this.deploymentService.addDeploymentListener(this.deploymentListener);
            }
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListeners(String appId, MuleContext muleContext) {
        try {
            appId = this.configuration.overrideAppId(appId);
            if (appId == null) {
                return;
            }
            LOGGER.info("Registering listeners for application {}", (Object)appId);
            Object object = this.notificationListenersLock;
            synchronized (object) {
                if (!this.connectorListeners.containsKey(appId)) {
                    this.registerConnectorMessageNotification(muleContext);
                    ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.configuration, muleContext, this.pipelineRegistry, appId, new RamlBasedEndpointTemplateSupplier(muleContext));
                    muleContext.registerListener((ServerNotificationListener)connectorListener);
                    this.connectorListeners.put(appId, connectorListener);
                }
                if (!this.processorListeners.containsKey(appId)) {
                    ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.configuration, muleContext, this.pipelineRegistry, appId);
                    muleContext.registerListener((ServerNotificationListener)processorListener);
                    this.processorListeners.put(appId, processorListener);
                }
                if (!this.customListeners.containsKey(appId)) {
                    CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, appId);
                    muleContext.registerListener((ServerNotificationListener)customListener);
                    this.customListeners.put(appId, customListener);
                }
            }
        }
        catch (NotificationException e) {
            LOGGER.error("Could not register listeners for application " + appId, (Throwable)e);
        }
    }

    void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                this.configuration.setAppDeployed(appName);
                MuleContext context = app.getMuleContext();
                if (context == null) continue;
                this.registerListeners(appName, context);
                this.loadAppSpecificProperties(appName, CollectorAgentService.lookupStringProperties(context));
                this.provideAppStatsExtraFields(appName, context);
                this.agentConfigurator.generateAppLogConfigFile(appName, context.getExecutionClassLoader());
            }
        }
    }

    private void registerConnectorMessageNotification(MuleContext context) {
        ServerNotificationManager notificationManager = context.getNotificationManager();
        for (Set types : notificationManager.getInterfaceToTypes().values()) {
            if (!types.contains(ConnectorMessageNotification.class)) continue;
            return;
        }
        notificationManager.addInterfaceToType(ConnectorNotificationListener.class, ConnectorMessageNotification.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListeners(String appId, MuleContext muleContext) {
        String overrideAppId = this.configuration.overrideAppId(appId);
        if (overrideAppId != null) {
            LOGGER.info("Un-registering listeners for application {}", (Object)overrideAppId);
            Object object = this.notificationListenersLock;
            synchronized (object) {
                CustomNotificationListener customListener;
                ConnectorNotificationListener connectorListener;
                ProcessorNotificationListener processorListener = this.processorListeners.remove(overrideAppId);
                if (processorListener != null && muleContext != null) {
                    muleContext.unregisterListener((ServerNotificationListener)processorListener);
                }
                if ((connectorListener = this.connectorListeners.remove(overrideAppId)) != null && muleContext != null) {
                    muleContext.unregisterListener((ServerNotificationListener)connectorListener);
                }
                if ((customListener = this.customListeners.remove(overrideAppId)) != null && muleContext != null) {
                    muleContext.unregisterListener((ServerNotificationListener)customListener);
                }
            }
        }
    }

    void unregisterListenersForAllApps() {
        LOGGER.info("Stopping");
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                MuleContext appMuleContext = app.getMuleContext();
                String appName = this.configuration.overrideAppId(app.getArtifactName());
                if (appName == null) continue;
                this.unregisterListeners(appName, appMuleContext);
                this.appStatsHandler.unregisterApp(appName);
                this.configuration.removeAppSpecificProperties(appName);
            }
        }
    }

    static Map<String, String> lookupStringProperties(MuleContext appMuleContext) {
        try {
            return appMuleContext.getRegistry().lookupByType(String.class);
        }
        catch (Exception e) {
            return CollectorAgentService.lookupStringPropertiesBestEffort(appMuleContext);
        }
    }

    static Map<String, String> lookupStringPropertiesBestEffort(MuleContext appMuleContext) {
        HashMap<String, String> results = new HashMap<String, String>();
        MuleRegistry muleRegistry = appMuleContext.getRegistry();
        if (muleRegistry instanceof MuleRegistryHelper) {
            for (Registry registry : ((MuleRegistryHelper)muleRegistry).getRegistries()) {
                try {
                    results.putAll(registry.lookupByType(String.class));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to lookup properties from mule registry " + registry, (Throwable)e);
                }
            }
        }
        return results;
    }

    private void provideAppStatsExtraFields(String appName, MuleContext context) {
        this.appStatsHandler.addApiIds(this.configuration.overrideAppId(appName), this.apiMetadataExtractor.getApiIds(context));
        this.appStatsHandler.setMuleVersion(MuleManifest.getProductVersion());
    }

    private void registerAbpMetricsCollectors(String appName, MuleContext mc) {
        if (mc != null) {
            MuleStatsProviderImpl muleStatsProvider = new MuleStatsProviderImpl(mc);
            this.registerAbpMetricsCollectors(appName, muleStatsProvider);
            CorePricingStatsProviderImpl corePricingStatsProvider = new CorePricingStatsProviderImpl(mc, this.configuration);
            this.registerCorePricingMetricsCollectors(appName, corePricingStatsProvider);
        } else {
            LOGGER.error("Cannot enable collection of ABP metrics due to missing MuleContext");
        }
    }

    void registerAbpMetricsCollectorsForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                MuleContext mc = app.getMuleContext();
                if (mc == null) continue;
                this.registerAbpMetricsCollectors(appName, mc);
            }
        }
    }

    private class CollectorDeploymentListener
    extends AbstractDeploymentListener {
        private CollectorDeploymentListener() {
        }

        public void onDeploymentSuccess(String appName) {
            Application app;
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.deploymentService != null && (app = CollectorAgentService.this.deploymentService.findApplication(appName)) != null) {
                MuleContext context = app.getMuleContext();
                if (context != null) {
                    CollectorAgentService.this.registerAbpMetricsCollectors(appName, context);
                    if (CollectorAgentService.this.configuration.isEnabled()) {
                        CollectorAgentService.this.configuration.setAppDeployed(appName);
                        CollectorAgentService.this.unregisterListeners(appName, context);
                        CollectorAgentService.this.registerListeners(appName, context);
                        CollectorAgentService.this.loadAppSpecificProperties(appName, CollectorAgentService.lookupStringProperties(context));
                        CollectorAgentService.this.provideAppStatsExtraFields(appName, context);
                        CollectorAgentService.this.agentConfigurator.generateAppLogConfigFile(appName, context.getExecutionClassLoader());
                    }
                } else {
                    CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                }
            }
        }

        public void onUndeploymentStart(String appName) {
            CollectorAgentService.this.pipelineRegistry.unregister(appName);
            CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
            CollectorAgentService.this.customMetricHandler.unregister(appName);
            CollectorAgentService.this.agentConfigurator.deleteAppLogConfigFile(appName);
            CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
            CollectorAgentService.this.configuration.setAppUndeployed(appName);
        }
    }
}

