/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.Collection;
import java.util.Collections;

public class InvocationContextToFactTransformer
implements EventMapper<InvocationContext, Fact> {
    @Override
    public Collection<Event<Fact>> process(Event<InvocationContext> event) {
        String basePath;
        String sourceHeader;
        String hostHeader;
        InvocationContext.Action action;
        String clientId;
        String operation;
        String protocol;
        String endpoint;
        String remotePort;
        String remoteIp;
        String flowName;
        InvocationContext context = event.getValue();
        Fact result = new Fact();
        String connector = context.getConnector();
        if (connector != null) {
            result.setDimension("endpoint_type", connector);
        }
        if ((flowName = context.getFlowName()) != null) {
            result.setDimension("flow_id", flowName);
        }
        if ((remoteIp = context.getRemoteHost()) != null) {
            result.setDimension("remote_host", remoteIp);
        }
        if ((remotePort = context.getRemotePort()) != null) {
            result.setDimension("remote_port", remotePort);
        }
        if ((endpoint = context.getEndpoint()) != null) {
            result.setDimension("endpoint", endpoint);
        }
        if ((protocol = context.getProtocol()) != null) {
            result.setDimension("protocol", protocol);
        }
        if ((operation = context.getOperation()) != null) {
            result.setDimension("operation", operation);
        }
        if ((clientId = context.getClientId()) != null) {
            result.setDimension("client_id", clientId);
        }
        if ((action = context.getAction()) != null) {
            result.setAttribute(Fact.Attribute.ACTION, (Object)action);
        }
        if ((hostHeader = context.getHostHeader()) != null) {
            result.setDimension("host_header", hostHeader);
        }
        if ((sourceHeader = context.getSourceHash()) != null) {
            result.setDimension("source_hash", sourceHeader);
        }
        if ((basePath = context.getBasePath()) != null) {
            result.setAttribute(Fact.Attribute.BASE_PATH, basePath);
        }
        if (context.isApiGatewayInvolved()) {
            result.setAttribute(Fact.Attribute.API_GATEWAY_INVOLVED, true);
        }
        return Collections.singleton(new Event<Fact>(event.getTime(), result, context.getInvocationId()));
    }
}

