/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import com.mulesoft.dias.mule.agent.AgentEncryptionException;
import com.mulesoft.dias.mule.agent.ConfigurationEncryptor;
import com.mulesoft.dias.mule.agent.EncryptionService;
import com.mulesoft.dias.mule.agent.SecretNotFoundException;
import com.mulesoft.dias.mule.agent.YamlWrapper;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MuleAgentDescriptorWrapper
implements ConfigurationEncryptor {
    private static final String KEYSTORE_PASSWORD_KEY = "keyStorePassword";
    private static final String KEYSTORE_ALIAS_PASSWORD_KEY = "keyStoreAliasPassword";
    private static final String GLOBAL_CONFIGURATION_KEY = "globalConfiguration";
    private static final String SECURITY_KEY = "security";
    private static final String PROXY_CONFIGURATION_KEY = "proxyConfiguration";
    private static final String PROXY_KERBEROS_CONFIGURATION_KEY = "proxyKerberosConfiguration";
    private static final String PROXY_PASSWORD_KEY = "password";
    private YamlWrapper yamlWrapper;
    private String descriptorFilePath;
    private Map<String, Object> configuration;
    private EncryptionService passwordEncryptor;

    private MuleAgentDescriptorWrapper(YamlWrapper yamlWrapper) {
        this.yamlWrapper = yamlWrapper;
    }

    public static MuleAgentDescriptorWrapper newInstance(YamlWrapper yamlWrapper) {
        return new MuleAgentDescriptorWrapper(yamlWrapper);
    }

    public MuleAgentDescriptorWrapper addPasswordEncryptor(EncryptionService passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
        return this;
    }

    public MuleAgentDescriptorWrapper load(String descriptorFilePath) throws IOException {
        this.descriptorFilePath = descriptorFilePath;
        try (FileReader reader = new FileReader(descriptorFilePath);){
            this.configuration = this.yamlWrapper.load(reader);
        }
        return this;
    }

    protected Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getKeystorePassword() {
        return this.getSecurity().map(config -> (String)config.get(KEYSTORE_PASSWORD_KEY)).orElse(null);
    }

    public void setKeystorePassword(String newValue) {
        this.getSecurity().ifPresent(config -> config.put(KEYSTORE_PASSWORD_KEY, newValue));
    }

    public String getKeystoreAliasPassword() {
        return this.getSecurity().map(config -> (String)config.get(KEYSTORE_ALIAS_PASSWORD_KEY)).orElse(null);
    }

    public void setKeystoreAliasPassword(String newValue) {
        this.getSecurity().ifPresent(config -> config.put(KEYSTORE_ALIAS_PASSWORD_KEY, newValue));
    }

    public MuleAgentDescriptorWrapper decryptPasswords() throws AgentEncryptionException {
        this.decryptKeystorePassword();
        this.decryptKeystoreAliasPassword();
        this.decryptProxyPassword();
        return this;
    }

    @Override
    public void encryptKeystorePassword() throws AgentEncryptionException, IOException {
        String secret = this.getKeystorePassword();
        if (secret == null) {
            throw new SecretNotFoundException("Keystore password not found");
        }
        this.setKeystorePassword(this.passwordEncryptor.encrypt(secret));
        this.save();
    }

    @Override
    public void encryptKeystoreAliasPassword() throws AgentEncryptionException, IOException {
        String secret = this.getKeystoreAliasPassword();
        if (secret == null) {
            throw new SecretNotFoundException("Keystore alias password not found");
        }
        this.setKeystoreAliasPassword(this.passwordEncryptor.encrypt(secret));
        this.save();
    }

    @Override
    public void encryptProxyPassword() throws AgentEncryptionException, IOException {
        String secret = this.getProxyPassword();
        if (secret == null) {
            throw new SecretNotFoundException("Proxy password not found");
        }
        this.setProxyPassword(this.passwordEncryptor.encrypt(secret));
        this.save();
    }

    @Override
    public void decryptKeystorePassword() throws AgentEncryptionException {
        String secret = this.getKeystorePassword();
        if (secret == null) {
            return;
        }
        this.setKeystorePassword(this.passwordEncryptor.decrypt(secret));
    }

    @Override
    public void decryptKeystoreAliasPassword() throws AgentEncryptionException {
        String secret = this.getKeystoreAliasPassword();
        if (secret == null) {
            return;
        }
        this.setKeystoreAliasPassword(this.passwordEncryptor.decrypt(secret));
    }

    @Override
    public void decryptProxyPassword() throws AgentEncryptionException {
        String secret = this.getProxyPassword();
        if (secret == null) {
            return;
        }
        this.setProxyPassword(this.passwordEncryptor.decrypt(secret));
    }

    public void save() throws IOException {
        this.yamlWrapper.dumpSafe(this.configuration, Paths.get(this.descriptorFilePath, new String[0]));
    }

    public void print(Writer ouput) {
        this.yamlWrapper.dump(this.configuration, ouput);
    }

    public ConfigurationEncryptor toConfigurationEncryptor() {
        return this;
    }

    private Optional<Map<String, Object>> getGloblalConfiguration() {
        if (this.configuration != null && this.configuration.containsKey(GLOBAL_CONFIGURATION_KEY)) {
            return Optional.ofNullable((Map)this.configuration.get(GLOBAL_CONFIGURATION_KEY));
        }
        return Optional.empty();
    }

    private Optional<Map<String, Object>> getSecurity() {
        return this.getGloblalConfiguration().map(config -> config.get(SECURITY_KEY)).filter(Objects::nonNull).map(value -> (Map)value);
    }

    private Optional<Map<String, Object>> getProxyConfiguration() {
        return this.getGloblalConfiguration().map(config -> config.get(PROXY_CONFIGURATION_KEY)).filter(Objects::nonNull).map(value -> (Map)value);
    }

    public String getProxyPassword() {
        return this.getProxyConfiguration().map(config -> (String)config.get(PROXY_PASSWORD_KEY)).orElse(null);
    }

    public void setProxyPassword(String newValue) {
        this.getProxyConfiguration().ifPresent(config -> config.put(PROXY_PASSWORD_KEY, newValue));
    }

    protected YamlWrapper getYamlWrapper() {
        return this.yamlWrapper;
    }

    protected EncryptionService getPasswordEncryptor() {
        return this.passwordEncryptor;
    }
}

