/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.abp;

import com.mulesoft.analytics.collector.abp.CorePricingStatsProvider;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CorePricingStatsProducer
implements EventProducer<Fact> {
    private static final Logger LOGGER = LogManager.getLogger(CorePricingStatsProducer.class);
    private CorePricingStatsProvider corePricingStatsProvider;
    private final String appId;
    private final Configuration configuration;
    @Nullable
    private final String workerId;

    public CorePricingStatsProducer(CorePricingStatsProvider corePricingStatsProvider, Configuration configuration) {
        this.corePricingStatsProvider = corePricingStatsProvider;
        this.appId = configuration.getCorePricingAssetId();
        this.configuration = configuration;
        this.workerId = this.obfuscateWorkerId(configuration);
    }

    @Nullable
    String obfuscateWorkerId(Configuration configuration) {
        String workerId = configuration.getRuntimeId();
        if (configuration.getDeploymentType() == DeploymentType.RTF && workerId != null) {
            String appName = configuration.getRtfAppName();
            if (appName != null && workerId.startsWith(appName)) {
                workerId = workerId.substring(appName.length() + 1);
            } else {
                int pos = workerId.lastIndexOf("-");
                if (pos > 0 && (pos = workerId.lastIndexOf("-", pos - 1)) >= 0) {
                    workerId = workerId.substring(pos + 1);
                }
            }
        }
        return workerId;
    }

    @Override
    public Collection<Event<Fact>> produce() {
        if (!this.corePricingStatsProvider.isEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<Event<Fact>> result = new ArrayList<Event<Fact>>();
        Fact fact = new Fact();
        fact.setDimension("id", UUID.randomUUID().toString());
        fact.setLongMetric("timestamp", System.currentTimeMillis());
        fact.setDimension("master_org_id", this.configuration.getMasterOrgId());
        fact.setDimension("org_id", this.configuration.getOrgId());
        fact.setDimension("env_id", this.configuration.getEnvId());
        fact.setDimension("asset_id", this.appId);
        fact.setDimension("worker_id", this.workerId);
        fact.setLongMetric("usage_count", this.corePricingStatsProvider.getUsageCount());
        fact.setLongMetric("public_usage_count", this.corePricingStatsProvider.getPublicUsageCount());
        fact.setLongMetric("flow_count", this.corePricingStatsProvider.getFlowCount());
        result.add(new Event<Fact>(fact));
        return result;
    }
}

