/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.log.MeteringLogWriter;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeteringFactLogger
implements EventConsumer<Fact> {
    private static final Logger LOGGER = LogManager.getLogger(MeteringFactLogger.class);
    private final MeteringLogWriter meteringLogWriter;
    private final boolean billable;

    public MeteringFactLogger(MeteringLogWriter meteringLogWriter, boolean billable) {
        this.meteringLogWriter = meteringLogWriter;
        this.billable = billable;
    }

    @Override
    public void consume(Event<Fact> event) {
        Fact fact = event.getValue();
        Long timestampLong = fact.getLongMetric("timestamp");
        if (!this.checkValidLong(timestampLong, "timestamp")) {
            return;
        }
        String rootOrgIdDimension = fact.getDimension("master_org_id");
        if (!this.checkValidString(rootOrgIdDimension, "master_org_id")) {
            return;
        }
        Long usageCountLong = fact.getLongMetric("usage_count");
        if (!this.checkValidLong(usageCountLong, "usage_count")) {
            return;
        }
        Long publicUsageCountLong = fact.getLongMetric("public_usage_count");
        if (!this.checkValidLong(publicUsageCountLong, "public_usage_count")) {
            return;
        }
        String envIdDimension = fact.getDimension("env_id");
        if (!this.checkValidString(envIdDimension, "env_id")) {
            return;
        }
        String orgIdDimension = fact.getDimension("org_id");
        if (!this.checkValidString(orgIdDimension, "org_id")) {
            return;
        }
        Long flowCountLong = fact.getLongMetric("flow_count");
        if (!this.checkValidLong(flowCountLong, "flow_count")) {
            return;
        }
        String idDimension = fact.getDimension("id");
        if (!this.checkValidString(idDimension, "id")) {
            return;
        }
        String assetIdDimension = fact.getDimension("asset_id");
        if (!this.checkValidString(assetIdDimension, "asset_id")) {
            return;
        }
        String workerIdDimension = fact.getDimension("worker_id");
        if (!this.checkValidString(workerIdDimension, "worker_id")) {
            return;
        }
        String corePricingLogEntry = String.format("{\"format\":\"%s\",\"time\":%d,\"events\":[{\"root_org_id\":\"%s\",\"billable\":%b,\"usage_count\":%d,\"public_usage_count\":%d,\"env_id\":\"%s\",\"org_id\":\"%s\",\"flow_count\":%d,\"id\":\"%s\",\"asset_id\":\"%s\",\"worker_id\":\"%s\",\"timestamp\":%d}],\"metadata\":{\"schema_id\":\"%s\"}}", "v1", timestampLong, rootOrgIdDimension, this.billable, usageCountLong, publicUsageCountLong, envIdDimension, orgIdDimension, flowCountLong, idDimension, assetIdDimension, workerIdDimension, timestampLong, "invocation_schema_id");
        this.meteringLogWriter.write(corePricingLogEntry);
    }

    private boolean checkValidLong(@Nullable Long longValue, String fieldName) {
        if (longValue == null) {
            LOGGER.error("Input for " + fieldName + " is null");
            return false;
        }
        return true;
    }

    private boolean checkValidString(@Nullable String stringInput, String fieldName) {
        if (stringInput == null) {
            LOGGER.error("Input for " + fieldName + " is null");
            return false;
        }
        if (stringInput.isEmpty()) {
            LOGGER.error("Input for " + fieldName + " is empty");
            return false;
        }
        return true;
    }
}

