/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.base.Joiner;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.model.FileContent;
import com.mulesoft.analytics.collector.config.model.HarvesterType;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import com.mulesoft.analytics.collector.util.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.joda.time.DateTimeZone;

@Singleton
public class AgentConfigurator {
    private static final Logger LOGGER = LogManager.getLogger(AgentConfigurator.class);
    static final String APPLOG_TEMPLATE_FILE = "applog-pipeline-template.yml";
    static final String METRIC_TEMPLATE_FILE = "metric-pipeline-template.yml";
    static final String OTEL_COMMON_FILE = "otel-pipeline-common.yml";
    static final String PIPELINES_DIR = "pipelines";
    static final String OTEL_CONFIG_FILE = "otel-config.yml";
    private static final String METRIC_CONFIG_FILE = "_metric.yml";
    private static final String METRIC_V2_CONFIG_FILE = "_v2_metric.yml";
    private static final String CUSTOM_METRIC_CONFIG_FILE = "_custom_metric.yml";
    private static final String RAW_API_METRIC_CONFIG_FILE = "_raw_api_metric.yml";
    @Inject
    private Configuration configuration;

    Path getPipelinesDir() {
        return this.configuration.getAmConfigPath().resolve(PIPELINES_DIR);
    }

    Path getMetricConfigFile() {
        return this.getPipelinesDir().resolve(METRIC_CONFIG_FILE);
    }

    Path getMetricV2ConfigFile() {
        return this.getPipelinesDir().resolve(METRIC_V2_CONFIG_FILE);
    }

    Path getCustomMetricConfigFile() {
        return this.getPipelinesDir().resolve(CUSTOM_METRIC_CONFIG_FILE);
    }

    Path getRawApiMetricConfigFile() {
        return this.getPipelinesDir().resolve(RAW_API_METRIC_CONFIG_FILE);
    }

    Path getAppLogTemplateFile() {
        return this.configuration.getAmConfigPath().resolve(APPLOG_TEMPLATE_FILE);
    }

    Path getMetricTemplateFile() {
        return this.configuration.getAmConfigPath().resolve(METRIC_TEMPLATE_FILE);
    }

    Path getOTelTemplateFile() {
        return this.configuration.getAmConfigPath().resolve(OTEL_COMMON_FILE);
    }

    Path getOTelConfigFile() {
        return this.getPipelinesDir().resolve(OTEL_CONFIG_FILE).normalize();
    }

    public void generateCertsFromHarvesterConfigFile() {
        Optional.ofNullable(this.configuration.getRuntimeConfig()).map(RuntimeConfig::getHarvester).ifPresent(harvesterConfig -> {
            if (HarvesterType.FILEBEAT.equals((Object)harvesterConfig.getType())) {
                harvesterConfig.getConfigFiles().stream().filter(fc -> fc.getName().startsWith("certs")).forEach(this::processFileContent);
            } else {
                LOGGER.warn("Unsupported HarvesterType: {}", (Object)harvesterConfig.getType());
            }
        });
    }

    private void processFileContent(FileContent fc) {
        try {
            Path configFilePath = this.configuration.getAmConfigPath().resolve(fc.getName()).normalize();
            if (!configFilePath.startsWith(this.configuration.getAmConfigPath())) {
                throw new IllegalArgumentException("Illegal file path: " + configFilePath);
            }
            this.writeIfNotEqual(configFilePath.toFile(), fc.getContent());
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate filebeat config file: {}", (Object)fc.getName(), (Object)e);
        }
    }

    public void generateOTelCommonConfigFile() {
        Path OTelTemplateFile = this.getOTelTemplateFile();
        if (this.isConfigFileGenerationNeeded(OTelTemplateFile)) {
            String msg = "Generate otel-collector config file.";
            try {
                this.generateConfigFile(this.getOTelTemplateFile(), this.getOTelConfigFile(), this.generateEnvironmentSubs());
                LOGGER.info(msg);
            }
            catch (IOException e) {
                LOGGER.error(msg, (Throwable)e);
            }
        }
    }

    public void generateMetricLogConfigFile() {
        if (this.isConfigFileGenerationNeeded(this.getMetricTemplateFile())) {
            try {
                this.generateConfigFile(this.getMetricTemplateFile(), this.getMetricConfigFile(), this.generateMetricSubs(this.configuration.getMetricLogFileName()));
                this.generateConfigFile(this.getMetricTemplateFile(), this.getMetricV2ConfigFile(), this.generateMetricSubs(this.configuration.getMetricV2LogFileName()));
                this.generateConfigFile(this.getMetricTemplateFile(), this.getCustomMetricConfigFile(), this.generateMetricSubs(this.configuration.getCustomMetricLogFileName()));
                this.generateConfigFile(this.getMetricTemplateFile(), this.getRawApiMetricConfigFile(), this.generateMetricSubs(this.configuration.getRawApiMetricLogFileName()));
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate filebeat config file", (Throwable)e);
            }
        }
    }

    public void generateAppLogConfigFile(String appId, ClassLoader appClassLoader) {
        this.generateAppLogConfigFile(appId, (LoggerContext)LogManager.getContext(appClassLoader, true));
    }

    void generateAppLogConfigFile(String appId, LoggerContext context) {
        if (!this.configuration.isLogsForwardingEnabled()) {
            this.deleteAppLogConfigFile(appId);
            LOGGER.info("Disabling log forwarding for app: " + appId);
            return;
        }
        Path appLogConfigFile = this.getAppLogConfigFile(appId);
        if (this.isConfigFileGenerationNeeded(this.getAppLogTemplateFile())) {
            try {
                String logFile = this.getApplicationLogFile(context);
                if (logFile == null) {
                    LOGGER.error("Cannot resolve application log file for app: " + appId);
                } else {
                    this.generateConfigFile(this.getAppLogTemplateFile(), appLogConfigFile, this.generateAppLogSubs(logFile, appId));
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate filebeat config file for app: " + appId, (Throwable)e);
            }
        }
    }

    public void deleteAppLogConfigFile(String appId) {
        FileUtils.deleteQuietly((File)this.getAppLogConfigFile(appId).toFile());
    }

    boolean isConfigFileGenerationNeeded(Path templateFile) {
        if (!Files.isDirectory(this.configuration.getAmConfigPath(), new LinkOption[0])) {
            return false;
        }
        if (!Files.isRegularFile(templateFile, new LinkOption[0])) {
            LOGGER.error("Not found " + templateFile);
            return false;
        }
        return true;
    }

    private Path getAppLogConfigFile(String appId) {
        return this.getPipelinesDir().resolve(appId + ".yml");
    }

    @Nullable
    private String getApplicationLogFile(LoggerContext context) {
        String logFile = null;
        for (Appender appender : context.getConfiguration().getAppenders().values()) {
            if (appender instanceof RollingFileAppender) {
                logFile = ((RollingFileAppender)appender).getFileName();
                continue;
            }
            if (appender instanceof RollingRandomAccessFileAppender) {
                logFile = ((RollingRandomAccessFileAppender)appender).getFileName();
                continue;
            }
            if (!(appender instanceof FileAppender)) continue;
            logFile = ((FileAppender)appender).getFileName();
        }
        return logFile;
    }

    String replaceSystemProperties(String line) {
        return StrSubstitutor.replaceSystemProperties((Object)line);
    }

    private void generateConfigFile(Path templateFile, Path configFile, Map<String, String> subs) throws IOException {
        List<String> input = Files.readAllLines(templateFile, StandardCharsets.UTF_8);
        ArrayList<String> output = new ArrayList<String>();
        for (String line : input) {
            try {
                line = this.replaceSystemProperties(line);
            }
            catch (NullPointerException e) {
                LOGGER.warn("Null pointer exception while replacing system properties in this line (skipped): " + line);
            }
            catch (Exception e) {
                LOGGER.warn("Unknown exception while replacing system properties in this line (skipped): " + line, (Throwable)e);
            }
            for (Map.Entry<String, String> entry : subs.entrySet()) {
                line = StringUtils.replace((String)line, (String)entry.getKey(), (String)entry.getValue());
            }
            output.add(line);
        }
        System.out.println("Lines to be added to the config file");
        output.forEach(System.out::println);
        this.writeIfNotEqual(configFile.toFile(), Joiner.on((String)System.lineSeparator()).join(output));
    }

    private Map<String, String> generateMetricSubs(String metricLogFile) {
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put("${log.file}", metricLogFile);
        String fileName = Paths.get(metricLogFile, new String[0]).getFileName().toString();
        subs.put("${log.file.name}", fileName);
        subs.putAll(this.generateEnvironmentSubs());
        return subs;
    }

    private Map<String, String> generateAppLogSubs(String logFile, String appId) {
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put("${log.file}", logFile);
        subs.put("${app.id}", appId);
        subs.putAll(this.generateEnvironmentSubs());
        return subs;
    }

    private Map<String, String> generateEnvironmentSubs() {
        HashMap<String, String> subs = new HashMap<String, String>();
        Maps.putNonNull(subs, "${organization.id}", this.configuration.getOrgId());
        Maps.putNonNull(subs, "${master.organization.id}", this.configuration.getMasterOrgId());
        Maps.putNonNull(subs, "${environment.id}", this.configuration.getEnvId());
        Maps.putNonNull(subs, "${environment.type}", this.configuration.getEnvType());
        Maps.putNonNull(subs, "${server.id}", this.configuration.getRuntimeId());
        Maps.putNonNull(subs, "${server.name}", this.configuration.getServerName());
        Maps.putNonNull(subs, "${cluster.id}", this.configuration.getClusterId());
        Maps.putNonNull(subs, "${am.home}", this.configuration.getAmHomePath().toString());
        Maps.putNonNull(subs, "${am.config.home}", this.configuration.getAmConfigPath().toString());
        subs.put("${time.zone}", DateTimeZone.getDefault().getID());
        subs.put("${proxy.url}", Optional.ofNullable(this.configuration.getProxyUrl()).orElse(""));
        RuntimeConfig runtimeConfig = this.configuration.getRuntimeConfig();
        if (runtimeConfig != null && runtimeConfig.getIngestionConfig() != null) {
            System.out.println("Received ingestion config: " + runtimeConfig.getIngestionConfig());
            runtimeConfig.getIngestionConfig().forEach((key, value) -> Maps.putNonNull(subs, "${" + key + "}", value));
        }
        return subs;
    }

    private void writeIfNotEqual(File file, String content) throws IOException {
        boolean shouldWrite;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(content.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = baos.toByteArray();
        try (InputStreamReader inputOld = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
             InputStreamReader input = new InputStreamReader(new ByteArrayInputStream(bytes));){
            shouldWrite = !IOUtils.contentEqualsIgnoreEOL((Reader)inputOld, (Reader)input);
        }
        catch (FileNotFoundException e) {
            shouldWrite = true;
        }
        if (shouldWrite) {
            FileUtils.write((File)file, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        }
    }
}

