/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.xmss;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Set;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CipherParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXMSSMTPrivateKey
implements PrivateKey,
XMSSMTPrivateKey {
    private static final long serialVersionUID = 7682140473044521395L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSMTPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    public long getIndex() {
        if (this.getUsagesRemaining() == 0L) {
            throw new IllegalStateException("key exhausted");
        }
        return this.keyParams.getIndex();
    }

    public long getUsagesRemaining() {
        return this.keyParams.getUsagesRemaining();
    }

    public XMSSMTPrivateKey extractKeyShard(int n) {
        return new BCXMSSMTPrivateKey(this.treeDigest, this.keyParams.extractKeyShard(n));
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.keyParams, (ASN1Set)this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            return this.treeDigest.equals(bCXMSSMTPrivateKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), bCXMSSMTPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName((ASN1ObjectIdentifier)this.treeDigest);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

