/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.configurator;

import com.mulesoft.dias.configurator.AgentConfigurator;
import com.mulesoft.dias.exception.AgentConfiguratorException;
import com.mulesoft.dias.mule.agent.CertificateProcessor;
import com.mulesoft.dias.mule.agent.unified.AgentInstaller;
import com.mulesoft.dias.mule.agent.version.MuleVersion;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.ExceptionUtils;
import com.mulesoft.dias.util.InstallerMessages;
import java.io.File;

public class AgentConfiguratorApp {
    public static void main(String[] args) {
        block8: {
            InstallerMessages.loadMessages();
            if (args.length > 0) {
                File file = new File(args[0]);
                if (file.isDirectory()) {
                    System.getProperties().setProperty("muleHome", args[0]);
                    System.setProperty("mule.home", args[0]);
                    try {
                        MuleVersion.detect();
                        AgentInstaller agentInstaller = new AgentInstaller();
                        agentInstaller.copyAgentJar();
                        agentInstaller.writeServerId();
                        agentInstaller.adjustFilebeatRegistry();
                        agentInstaller.writeToWrapperConfFile();
                        AgentConfigurator agentConfigurator = new AgentConfigurator();
                        boolean isConfigPushSuccessful = agentConfigurator.pushConfiguration();
                        if (isConfigPushSuccessful) {
                            CertificateProcessor certificateProcessor = new CertificateProcessor();
                            certificateProcessor.processCertificates();
                            break block8;
                        }
                        ConsoleLogger.debug("Certificates not processed due to failure in configuration push.");
                    }
                    catch (AgentConfiguratorException e) {
                        ConsoleLogger.error(e.getMessage());
                    }
                    catch (Exception e) {
                        ConsoleLogger.error(InstallerMessages.unexpectedError() + "\n\tException: " + ExceptionUtils.restrictStackTrace(e));
                    }
                } else {
                    ConsoleLogger.error(InstallerMessages.noMuleHomeProvidedMessage());
                }
            } else {
                ConsoleLogger.error(InstallerMessages.notProvidedMuleHome());
            }
        }
    }
}

