/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class MuleAgentConfig {
    private static final String KEY_STORE_PASSWORD = "keyStorePassword";
    private static final String ENDPOINT = "endpoint";
    private static final String GLOBAL_CONFIGURATION = "globalConfiguration";
    private static final String SECURITY = "security";
    private static final String AUTHENTICATION_PROXY = "authenticationProxy";
    private static final String PROXY_CONFIGURATION = "proxyConfiguration";
    private static final String PROXY_HOST = "host";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "user";
    private static final String PROXY_PASSWORD = "password";
    private static final String TRAFFIC_INSPECTION_ENABLED = "trafficInspectionEnabled";
    private static final String ENVIRONMENT = "environment";
    private static final String ONPREM = "on-prem";
    private HashMap<Object, Object> root;

    public MuleAgentConfig(String content) {
        Yaml yaml = new Yaml();
        this.root = (HashMap)yaml.load(content);
    }

    private Map getSecurity() {
        Map m = this.getCG();
        if (m != null) {
            return (Map)m.get(SECURITY);
        }
        return null;
    }

    private Map getCG() {
        return (Map)this.root.get(GLOBAL_CONFIGURATION);
    }

    private Map getAuthenticationProxy() {
        Map m = this.getCG();
        if (m != null) {
            return (Map)m.get(AUTHENTICATION_PROXY);
        }
        return null;
    }

    public String getAuthenticationProxyEndpoint() {
        Map authenticationProxy = this.getAuthenticationProxy();
        if (authenticationProxy != null) {
            return (String)authenticationProxy.get(ENDPOINT);
        }
        return null;
    }

    public String getKeyStorePassword() {
        Map security = this.getSecurity();
        if (security != null) {
            return (String)security.get(KEY_STORE_PASSWORD);
        }
        return null;
    }

    private Map getProxyConfiguration() {
        Map m = this.getCG();
        if (m != null) {
            return (Map)m.get(PROXY_CONFIGURATION);
        }
        return null;
    }

    public String getProxyHost() {
        Map security = this.getProxyConfiguration();
        if (security != null) {
            return (String)security.get(PROXY_HOST);
        }
        return null;
    }

    public Integer getProxyPort() {
        Object portValue;
        Map proxyConfig = this.getProxyConfiguration();
        if (proxyConfig != null && (portValue = proxyConfig.get(PROXY_PORT)) != null) {
            return (Integer)portValue;
        }
        return null;
    }

    public String getProxyUser() {
        Map security = this.getProxyConfiguration();
        if (security != null) {
            return (String)security.get(PROXY_USER);
        }
        return null;
    }

    public String getProxyPassword() {
        Map security = this.getProxyConfiguration();
        if (security != null) {
            return (String)security.get(PROXY_PASSWORD);
        }
        return null;
    }

    public boolean isTrafficInspectionEnabled() {
        Object trafficInspectionValue;
        Map proxyConfig = this.getProxyConfiguration();
        if (proxyConfig != null && (trafficInspectionValue = proxyConfig.get(TRAFFIC_INSPECTION_ENABLED)) instanceof Boolean) {
            return (Boolean)trafficInspectionValue;
        }
        return false;
    }

    public boolean isOnPrem() {
        return ONPREM.equals(this.root.get(ENVIRONMENT));
    }
}

