/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingleTimeoutTaskExecutor {
    private final ScheduledExecutorService executor;
    private final long timeoutDelay;
    private final TimeUnit timeoutUnit;
    private final AtomicBoolean busy = new AtomicBoolean();

    public SingleTimeoutTaskExecutor(String nameFormat, long timeoutDelay, TimeUnit timeoutUnit) {
        this.executor = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat(nameFormat).build());
        this.timeoutDelay = timeoutDelay;
        this.timeoutUnit = timeoutUnit;
    }

    public void execute(final Runnable task) {
        if (this.executor.isShutdown()) {
            return;
        }
        if (this.busy.compareAndSet(false, true)) {
            final Future<?> taskHandler = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        SingleTimeoutTaskExecutor.this.busy.set(false);
                    }
                }
            });
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    taskHandler.cancel(true);
                }
            }, this.timeoutDelay, this.timeoutUnit);
        }
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }
}

