/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.configurator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.service.DefaultAuthenticationProxyFactory;
import com.mulesoft.dias.service.ProxyServerFactory;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.InstallerMessages;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public class AgentConfigurator {
    private static final String PROVISIONING_CONFIG_REGISTER = "/dias/provisioning/register/api/v1";

    public boolean pushConfiguration() throws IOException, URISyntaxException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        ConsoleLogger.info("Starting agent configuration process...");
        String agentConfig = new String(Files.readAllBytes(MuleHomePath.getConfigPath("mule-agent.yml")));
        ConsoleLogger.info("Loaded mule-agent.yml configuration");
        MuleAgentConfig muleAgent = new MuleAgentConfig(agentConfig);
        String keyStorePassword = muleAgent.getKeyStorePassword();
        String authenticationProxyEndpoint = muleAgent.getAuthenticationProxyEndpoint();
        if (keyStorePassword == null || authenticationProxyEndpoint == null) {
            ConsoleLogger.error("Error: Required configuration properties are missing:");
            if (keyStorePassword == null) {
                ConsoleLogger.error("- KeyStore password is missing");
            }
            if (authenticationProxyEndpoint == null) {
                ConsoleLogger.error("- Authentication proxy endpoint is missing");
            }
            ConsoleLogger.error(InstallerMessages.agentConfigPropertyMissing());
            System.exit(-1);
        }
        ConsoleLogger.info("Configuration properties validated successfully");
        ConsoleLogger.info("Initializing authentication proxy client...");
        DefaultAuthenticationProxyFactory defaultAuthenticationProxyFactory = new DefaultAuthenticationProxyFactory();
        URI uri = new URI(authenticationProxyEndpoint);
        ConsoleLogger.info("Authentication proxy endpoint: " + authenticationProxyEndpoint);
        AuthenticationProxyClient authenticationProxyClient = defaultAuthenticationProxyFactory.create(keyStorePassword, new ObjectMapper(), uri, muleAgent);
        ConsoleLogger.info("Authentication proxy client initialized successfully");
        ConsoleLogger.info("Pushing configuration to ARM...");
        Response response = this.pushConfigurationToArm(muleAgent, authenticationProxyClient);
        boolean isSuccessful = AgentConfigurator.isPushConfigurationSuccessful(response);
        ConsoleLogger.info("Configuration push " + (isSuccessful ? "completed successfully" : "failed"));
        authenticationProxyClient.close();
        ConsoleLogger.info("Authentication proxy client closed");
        return isSuccessful;
    }

    private Response pushConfigurationToArm(MuleAgentConfig muleAgent, AuthenticationProxyClient authenticationProxyClient) {
        String proxyHost = muleAgent.getProxyHost();
        Integer proxyPort = muleAgent.getProxyPort();
        if (proxyHost == null && proxyPort == null) {
            ConsoleLogger.info("No proxy configuration found, proceeding with direct connection");
            return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER);
        }
        if (proxyHost == null || proxyPort == null) {
            ConsoleLogger.error("Error: Incomplete proxy configuration:");
            if (proxyHost == null) {
                ConsoleLogger.error("- Proxy host is missing");
            }
            if (proxyPort == null) {
                ConsoleLogger.error("- Proxy port is missing");
            }
            ConsoleLogger.error(InstallerMessages.proxyConfigMissing());
            System.exit(-1);
        }
        ConsoleLogger.info("Using proxy configuration - Host: " + proxyHost + ", Port: " + proxyPort);
        String proxyUser = muleAgent.getProxyUser();
        String proxyPassword = muleAgent.getProxyPassword();
        if (proxyUser != null) {
            ConsoleLogger.info("Proxy authentication enabled");
        }
        ProxyServer.Builder proxyBuilder = new ProxyServerFactory().create(proxyHost, proxyPort, proxyUser != null ? proxyUser : "", proxyPassword != null ? proxyPassword : "");
        if (muleAgent.isTrafficInspectionEnabled()) {
            ConsoleLogger.info("Traffic inspection is enabled");
        }
        ConsoleLogger.info("Sending configuration to ARM through proxy...");
        return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER, proxyBuilder.build());
    }

    private static boolean isPushConfigurationSuccessful(Response response) throws IOException {
        String line;
        int responseCode = response.getStatusCode();
        ConsoleLogger.info("Received response from ARM - Status code: " + responseCode);
        if (responseCode == 200) {
            ConsoleLogger.info(InstallerMessages.agentConfigSuccessfully());
            return true;
        }
        if (responseCode == 401) {
            ConsoleLogger.error(InstallerMessages.unauthorized());
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Failed request with code ").append(responseCode).append(".");
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseBodyAsStream()));
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        ConsoleLogger.error("Error response from ARM: " + stringBuilder.toString());
        return false;
    }
}

