/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.country.CountryLookup;
import com.mulesoft.analytics.collector.country.CountryLookupImpl;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CountryMapper
implements EventMapper<Fact, Fact> {
    private static final Logger LOGGER = LogManager.getLogger(CountryMapper.class);
    private final Configuration configuration;
    @Nullable
    private final CountryLookup countryLookup;

    public CountryMapper(Configuration configuration) {
        this.configuration = configuration;
        this.countryLookup = this.initCountryLookup();
    }

    CountryMapper(Configuration configuration, @Nullable CountryLookup countryLookup) {
        this.configuration = configuration;
        this.countryLookup = countryLookup;
    }

    @Nullable
    private CountryLookup initCountryLookup() {
        try {
            Path countryDbPath = this.configuration.getCountryDbPath();
            String countryDbFilename = this.configuration.getExistingCountryDbFilename();
            if (countryDbFilename == null) {
                LOGGER.info("Country database not found. Country lookup disabled.");
                return null;
            }
            return new CountryLookupImpl(countryDbPath.resolve(countryDbFilename).toFile());
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize country lookup. Country lookup disabled.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact;
        String clientIp;
        if (this.countryLookup != null && this.configuration.isApiCountryMetricEnabled() && (clientIp = (fact = event.getValue()).getDimension("remote_host")) != null) {
            fact.setDimension("country", this.countryLookup.country(clientIp));
        }
        return Collections.singleton(event);
    }
}

