/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec;

import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECConstants;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECCurve;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECFieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECLookupTable;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.ECPoint;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP521R1Field;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP521R1FieldElement;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.ec.custom.sec.SecP521R1Point;
import com.mulesoft.analytics.collector.shaded.bouncycastle.math.raw.Nat;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP521R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP521R1FieldElement.Q;
    private static final int SECP521R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP521R1_AFFINE_ZS = new ECFieldElement[]{new SecP521R1FieldElement(ECConstants.ONE)};
    protected SecP521R1Point infinity = new SecP521R1Point((ECCurve)this, null, null);

    public SecP521R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00")));
        this.order = new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP521R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP521R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP521R1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP521R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 17 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 17);
            n3 += 17;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP521R1_AFFINE_ZS;
    }
}

