/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.sphincsplus;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.CipherParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSPlusPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.spec.SPHINCSPlusParameterSpec;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCSPHINCSPlusPublicKey
implements SPHINCSPlusPublicKey {
    private static final long serialVersionUID = 1L;
    private transient SPHINCSPlusPublicKeyParameters params;

    public BCSPHINCSPlusPublicKey(SPHINCSPlusPublicKeyParameters sPHINCSPlusPublicKeyParameters) {
        this.params = sPHINCSPlusPublicKeyParameters;
    }

    public BCSPHINCSPlusPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (SPHINCSPlusPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSPHINCSPlusPublicKey) {
            BCSPHINCSPlusPublicKey bCSPHINCSPlusPublicKey = (BCSPHINCSPlusPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSPHINCSPlusPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "SPHINCS+-" + Strings.toUpperCase(this.params.getParameters().getName());
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public SPHINCSPlusParameterSpec getParameterSpec() {
        return SPHINCSPlusParameterSpec.fromName((String)this.params.getParameters().getName());
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

