/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.EventAggregate;
import com.mulesoft.analytics.limiter.MetricAggregate;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.DoubleAggregate;
import com.mulesoft.analytics.limiter.data.LongAggregate;
import com.mulesoft.analytics.limiter.data.ValueVector;
import java.util.Arrays;

public class UserEventAggregate
implements EventAggregate {
    private UserEvent sampleEvent;
    private int eventCount;
    private NamePath[] collapsibleDimensions;
    private NamePath[] longMetricDimensions;
    private NamePath[] doubleMetricDimensions;
    private LongAggregate[] longAggregates;
    private DoubleAggregate[] doubleAggregates;
    private ValueVector valueVector;

    public UserEventAggregate(UserEvent firstEvent, ValueVector v, NamePath[] collapsibleDimensions, NamePath[] longMetricDims, NamePath[] doubleMetricDims) {
        int i;
        this.sampleEvent = firstEvent;
        this.valueVector = v;
        this.collapsibleDimensions = collapsibleDimensions;
        this.longMetricDimensions = longMetricDims;
        this.doubleMetricDimensions = doubleMetricDims;
        if (this.longMetricDimensions != null) {
            this.longAggregates = new LongAggregate[this.longMetricDimensions.length];
            for (i = 0; i < this.longMetricDimensions.length; ++i) {
                this.longAggregates[i] = new LongAggregate(this.longMetricDimensions[i]);
            }
        }
        if (this.doubleMetricDimensions != null) {
            this.doubleAggregates = new DoubleAggregate[this.doubleMetricDimensions.length];
            for (i = 0; i < this.doubleMetricDimensions.length; ++i) {
                this.doubleAggregates[i] = new DoubleAggregate(this.doubleMetricDimensions[i]);
            }
        }
    }

    @Override
    public void addEvent(UserEvent theUserEvent) {
        int i;
        Object[] values;
        ++this.eventCount;
        if (this.longMetricDimensions != null && this.longMetricDimensions.length > 0) {
            values = theUserEvent.getLongMetrics(this.longMetricDimensions);
            for (i = 0; i < this.longMetricDimensions.length; ++i) {
                this.longAggregates[i].appendLong(values[i]);
            }
        }
        if (this.doubleMetricDimensions != null && this.doubleMetricDimensions.length > 0) {
            values = theUserEvent.getDoubleMetrics(this.doubleMetricDimensions);
            for (i = 0; i < this.doubleMetricDimensions.length; ++i) {
                this.doubleAggregates[i].appendDouble(values[i]);
            }
        }
    }

    @Override
    public UserEvent getSampleEvent() {
        return this.sampleEvent;
    }

    @Override
    public Object[] getCollapsibleValues() {
        if (this.valueVector == null) {
            return null;
        }
        return this.valueVector.getValues();
    }

    @Override
    public NamePath[] getCollapsibleDimensions() {
        return this.collapsibleDimensions;
    }

    @Override
    public MetricAggregate[] getMetricAggregates() {
        if (this.longAggregates == null && this.doubleAggregates == null) {
            return null;
        }
        if (this.longAggregates == null || this.longAggregates.length <= 0) {
            return this.doubleAggregates;
        }
        if (this.doubleAggregates == null || this.doubleAggregates.length <= 0) {
            return this.longAggregates;
        }
        if (this.longAggregates.length <= 0 && this.doubleAggregates.length <= 0) {
            return null;
        }
        MetricAggregate[] result = new MetricAggregate[this.longAggregates.length + this.doubleAggregates.length];
        System.arraycopy(this.longAggregates, 0, result, 0, this.longAggregates.length);
        System.arraycopy(this.doubleAggregates, 0, result, this.longAggregates.length, this.doubleAggregates.length);
        return result;
    }

    @Override
    public ValueVector getValueVector() {
        return this.valueVector;
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public int addEventCount(int numEvents) {
        this.eventCount += numEvents;
        return this.eventCount;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.valueVector).append(" => {count = ").append(this.eventCount);
        if (this.longAggregates != null && this.longAggregates.length > 0) {
            out.append(", long metrics = [");
            for (MetricAggregate metricAggregate : this.longAggregates) {
                out.append(metricAggregate).append(", ");
            }
            out.append("]");
        }
        if (this.doubleAggregates != null && this.doubleAggregates.length > 0) {
            out.append(", double metrics = [");
            for (MetricAggregate metricAggregate : this.doubleAggregates) {
                out.append(metricAggregate).append(", ");
            }
            out.append("]");
        }
        out.append("}");
        return out.toString();
    }

    public void mergeAggregate(UserEventAggregate other) {
        block8: {
            int i;
            block9: {
                int i2;
                if (!(Arrays.deepEquals(this.collapsibleDimensions, other.collapsibleDimensions) && Arrays.deepEquals(this.longMetricDimensions, other.longMetricDimensions) && Arrays.deepEquals(this.doubleMetricDimensions, other.doubleMetricDimensions))) {
                    throw new RuntimeException("Unable to merge two aggregates of different type.");
                }
                if (other.eventCount <= 0) break block8;
                if (this.eventCount != 0) break block9;
                this.eventCount = other.eventCount;
                if (other.longAggregates != null) {
                    this.longAggregates = new LongAggregate[other.longAggregates.length];
                    for (i2 = 0; i2 < other.longAggregates.length; ++i2) {
                        this.longAggregates[i2] = (LongAggregate)other.longAggregates[i2].duplicate();
                    }
                }
                if (other.doubleAggregates == null) break block8;
                this.doubleAggregates = new DoubleAggregate[other.doubleAggregates.length];
                for (i2 = 0; i2 < other.doubleAggregates.length; ++i2) {
                    this.doubleAggregates[i2] = (DoubleAggregate)other.doubleAggregates[i2].duplicate();
                }
                break block8;
            }
            this.eventCount += other.eventCount;
            if (this.longAggregates != null) {
                for (i = 0; i < this.longAggregates.length; ++i) {
                    this.longAggregates[i].merge(other.longAggregates[i]);
                }
            }
            if (this.doubleAggregates != null) {
                for (i = 0; i < this.doubleAggregates.length; ++i) {
                    this.doubleAggregates[i].merge(other.doubleAggregates[i]);
                }
            }
        }
    }
}

