/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.api.config.ApiGatewayComponentBuildingDefinitionProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;

@Singleton
public class ApiMetadataExtractor {
    static final Logger LOGGER = LogManager.getLogger(ApiMetadataExtractor.class);
    static String AUTODISCOVERY_CLASS = "com.mulesoft.mule.runtime.gw.autodiscovery.api.Autodiscovery";
    static String APIDISCOVERY_CLASS = "com.mulesoft.mule.runtime.gw.autodiscovery.api.ApiDiscovery";

    public Collection<String> getApiIds(Registry registry) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ClassLoader cl = ApiGatewayComponentBuildingDefinitionProvider.class.getClassLoader();
            try {
                Class<?> autoDiscClass = cl.loadClass(AUTODISCOVERY_CLASS);
                Collection autoDiscList = registry.lookupAllByType(autoDiscClass);
                Method method = autoDiscClass.getMethod("getApiKey", new Class[0]);
                for (Object autoDisc : autoDiscList) {
                    ApiKey apiKey = (ApiKey)method.invoke(autoDisc, new Object[0]);
                    result.add(apiKey.id().toString());
                }
            }
            catch (Exception e) {
                Class<?> c = cl.loadClass(APIDISCOVERY_CLASS);
                Object discovery = c.newInstance();
                Method method = c.getMethod("apiKeys", Registry.class);
                Collection keys = (Collection)method.invoke(discovery, registry);
                for (ApiKey key : keys) {
                    result.add(key.id().toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot extract API Metadata", (Throwable)e);
        }
        return result;
    }
}

