/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;

public class MuleUtils {
    public static final Logger LOGGER = LogManager.getLogger(MuleUtils.class);

    private MuleUtils() {
    }

    public static <T> Optional<T> registryLookupByType(String appId, Registry registry, Class<T> objectType) {
        try {
            return registry.lookupByType(objectType);
        }
        catch (Exception e) {
            LOGGER.warn("Mule registry lookup failed for app " + appId, (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> registryLookupByName(String appId, Registry registry, String name) {
        try {
            return registry.lookupByName(name);
        }
        catch (Exception e) {
            LOGGER.warn("Mule registry lookup failed for app " + appId, (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<RegionClassLoader> getAppRegionClassLoader(Application app) {
        try {
            return Optional.ofNullable(app.getRegionClassLoader());
        }
        catch (Exception e) {
            LOGGER.warn("Get app region class loader failed for app " + app.getArtifactName(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static Map<String, String> lookupStringProperties(String appId, Registry registry) {
        try {
            return registry.lookupByType(ConfigurationProperties.class).map(MuleUtils::extractProperties).orElse(Collections.emptyMap());
        }
        catch (Exception e) {
            LOGGER.warn("Lookup properties failed for app " + appId, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, String> extractProperties(ConfigurationProperties configurationProperties) {
        return MuleUtils.tryReadField(configurationProperties, "configurationPropertiesResolver").map(MuleUtils::resolveProperties).orElse(Collections.emptyMap());
    }

    private static Map<String, String> resolveProperties(Object resolver) {
        HashMap<String, String> properties = new HashMap<String, String>(MuleUtils.tryReadField(resolver, "configurationPropertiesProvider").map(MuleUtils::resolveCompositeProperties).orElse(Collections.emptyMap()));
        MuleUtils.tryReadField(resolver, "parentResolver").ifPresent(field -> {
            Optional parentResolver = (Optional)field;
            parentResolver.ifPresent(r -> properties.putAll(MuleUtils.resolveProperties(r)));
        });
        return properties;
    }

    private static Map<String, String> resolveCompositeProperties(Object provider) {
        HashMap<String, String> results = new HashMap<String, String>(MuleUtils.tryReadField(provider, "configurationAttributes").map(MuleUtils::attributesToMap).orElse(Collections.emptyMap()));
        if (results.isEmpty()) {
            MuleUtils.tryReadField(provider, "configurationPropertiesProviders").ifPresent(cps -> {
                List providers = (List)cps;
                providers.forEach(p -> results.putAll(MuleUtils.resolveCompositeProperties(p)));
            });
        }
        return results;
    }

    private static Map<String, String> attributesToMap(Object attributes) {
        HashMap<String, String> results = new HashMap<String, String>();
        Map props = (Map)attributes;
        props.forEach((k, v) -> {
            Object value = v.getRawValue();
            results.put((String)k, value instanceof String ? (String)value : value.toString());
        });
        return results;
    }

    private static Optional<Object> tryReadField(Object target, String fieldName) {
        try {
            return Optional.ofNullable(FieldUtils.readField((Object)target, (String)fieldName, (boolean)true));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

