/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.strategy;

import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.OtherValue;
import com.mulesoft.analytics.limiter.data.UserEventAggregate;
import com.mulesoft.analytics.limiter.data.ValueVector;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.StrategyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAggregationStrategy
implements EventLimiterStrategy {
    protected EventProcessorConfig config;
    protected Map<ValueVector, UserEventAggregate> eventAggregateByValue;
    protected UserEventAggregate otherEvent;
    protected StrategyState currentState;
    protected int numSamples;
    protected double numEvents;
    protected NamePath[] retainingDimensions;
    protected NamePath[] collapsibleDimensions;
    protected NamePath[] longMetricDimensions;
    protected NamePath[] doubleMetricDimensions;

    protected AbstractAggregationStrategy(EventProcessorConfig config) {
        this.configure(config);
        this.retainingDimensions = config.getRetainingDims();
        this.collapsibleDimensions = config.getCollapsibleDims();
        this.longMetricDimensions = config.getLongMetricDims();
        this.doubleMetricDimensions = config.getDoubleMetricDims();
        this.numEvents = 0.0;
        this.numSamples = 0;
    }

    @Override
    public void configure(EventProcessorConfig config) {
        if (config.getMaxOutput() + config.getAdaptiveConfig().getPerDimMaximumN() < 1) {
            throw new IllegalArgumentException("Sum of SamplingSize and MaxOutputSize must be positive");
        }
        if (config.getAdaptiveConfig().getPerDimMaximumN() == 0 && config.getMaxOutput() > config.getContainerSize()) {
            throw new IllegalArgumentException("If no sampling, MaxOutput must be less than ContainerSize");
        }
        if (config.getMaxOutput() == 0 && config.getAdaptiveConfig().getPerDimMaximumN() > config.getContainerSize()) {
            throw new IllegalArgumentException("If no sampling, MaxOutput must be less than ContainerSize");
        }
        this.config = config;
    }

    @Override
    public boolean isLimiting() {
        return true;
    }

    @Override
    public boolean isAggregating() {
        return true;
    }

    protected ValueVector getRetainingValues(UserEvent inputEvent) {
        if (this.retainingDimensions != null) {
            Object[] values = inputEvent.getDimensionValues(this.retainingDimensions);
            return new ValueVector(values);
        }
        return null;
    }

    protected ValueVector getCollapsibleValues(UserEvent inputEvent) {
        if (this.collapsibleDimensions != null) {
            Object[] values = inputEvent.getDimensionValues(this.collapsibleDimensions);
            return new ValueVector(values);
        }
        return null;
    }

    protected ValueVector getOtherValueVector() {
        Object[] otherVal = new Object[this.config.getCollapsibleDims().length];
        for (int i = 0; i < otherVal.length; ++i) {
            otherVal[i] = OtherValue.OTHER;
        }
        return new ValueVector(otherVal);
    }

    protected List<Map.Entry<ValueVector, UserEventAggregate>> getSortedEventList() {
        ArrayList<Map.Entry<ValueVector, UserEventAggregate>> resultList = new ArrayList<Map.Entry<ValueVector, UserEventAggregate>>();
        for (Map.Entry<ValueVector, UserEventAggregate> entry : this.eventAggregateByValue.entrySet()) {
            resultList.add(entry);
        }
        Collections.sort(resultList, new Comparator<Map.Entry<ValueVector, UserEventAggregate>>(){

            @Override
            public int compare(Map.Entry<ValueVector, UserEventAggregate> o1, Map.Entry<ValueVector, UserEventAggregate> o2) {
                return o2.getValue().getEventCount() - o1.getValue().getEventCount();
            }
        });
        return resultList;
    }

    @Override
    public void begin() {
        this.currentState = StrategyState.COLLECTING_SAMPLES;
        this.eventAggregateByValue = new HashMap<ValueVector, UserEventAggregate>();
        this.numSamples = 0;
        this.numEvents = 0.0;
    }

    @Override
    public StrategyState getState() {
        return this.currentState;
    }

    @Override
    public int getBufferSize() {
        return this.eventAggregateByValue.size();
    }
}

