/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import com.mulesoft.dias.mule.agent.CertificateProcessor;
import com.mulesoft.dias.mule.agent.DefaultFileWatchService;
import com.mulesoft.dias.mule.agent.FileWatchService;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DirectoryWatcher {
    private final FileWatchService watchService;
    private final Set<Path> watchedFiles = new HashSet<Path>();
    private final Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private final CertificateProcessor certificateProcessor;
    private final Path otelConfigPath;
    private final Path muleAgentJksPath;
    private final boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win");
    private final Map<Path, String> fileHashes = new HashMap<Path, String>();

    public DirectoryWatcher(FileWatchService watchService) throws IOException {
        String muleHome = System.getProperty("muleHome");
        if (muleHome == null || muleHome.isEmpty()) {
            throw new IllegalStateException("muleHome system property is not set");
        }
        this.watchService = watchService;
        this.certificateProcessor = new CertificateProcessor();
        this.otelConfigPath = MuleHomePath.getAMConfigPath("pipelines/otel-config.yml").toAbsolutePath();
        this.muleAgentJksPath = MuleHomePath.getConfigPath("mule-agent.jks").toAbsolutePath();
        if (Files.exists(this.otelConfigPath.getParent(), new LinkOption[0])) {
            this.forceProcessAllYamlFiles();
        }
        this.preloadHashes();
        this.registerDirectory(this.otelConfigPath.getParent());
        this.registerDirectory(this.muleAgentJksPath.getParent());
        ConsoleLogger.info("Watching directories for changes...");
        new Thread(this::monitorForNewDirectoriesAndFiles).start();
    }

    private void forceProcessAllYamlFiles() {
        try {
            Files.walkFileTree(this.otelConfigPath.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (DirectoryWatcher.this.isWindows && file.toString().toLowerCase().endsWith(".yml")) {
                        DirectoryWatcher.this.convertWindowsPathsToUnix(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            ConsoleLogger.error("Error while processing YAML files: " + e.getMessage());
        }
    }

    private void preloadHashes() {
        try {
            Files.walkFileTree(this.otelConfigPath.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (DirectoryWatcher.this.isWindows && file.toString().toLowerCase().endsWith(".yml")) {
                        DirectoryWatcher.this.fileHashes.put(file, DirectoryWatcher.this.hashContent(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            ConsoleLogger.error("Error while preloading hashes: " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private String hashContent(Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String hashContent(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            ConsoleLogger.error("Error hashing content " + content);
            e.printStackTrace(System.err);
            throw new RuntimeException("SHA-256 not supported", e);
        }
    }

    public DirectoryWatcher() throws IOException {
        this(new DefaultFileWatchService());
    }

    private void registerDirectory(Path directory) throws IOException {
        if (this.watchKeys.containsValue(directory)) {
            return;
        }
        WatchKey key = this.watchService.registerDirectory(directory);
        this.watchKeys.put(key, directory);
        ConsoleLogger.info("Watching directory: " + directory);
    }

    private boolean checkAndRegisterFile(Path file) {
        if (Files.exists(file, new LinkOption[0]) && !this.watchedFiles.contains(file)) {
            this.watchedFiles.add(file);
            if (this.isWindows && file.toString().toLowerCase().endsWith(".yml")) {
                this.convertWindowsPathsToUnix(file);
            }
            ConsoleLogger.info("File found and watching: " + file);
            return true;
        }
        if (!this.watchedFiles.contains(file)) {
            ConsoleLogger.info("File not found, will retry: " + file);
        }
        return false;
    }

    private void monitorForNewDirectoriesAndFiles() {
        boolean otelConfigFound = false;
        boolean muleAgentJksFound = false;
        try {
            do {
                TimeUnit.SECONDS.sleep(5L);
                if (!otelConfigFound) {
                    otelConfigFound = this.checkAndRegisterFile(this.otelConfigPath);
                }
                if (muleAgentJksFound) continue;
                muleAgentJksFound = this.checkAndRegisterFile(this.muleAgentJksPath);
            } while (!otelConfigFound || !muleAgentJksFound);
            ConsoleLogger.info("All required files are now being watched.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean convertWindowsPathsToUnix(Path yamlFilePath) {
        if (!this.isWindows) {
            ConsoleLogger.debug("Skip converting paths in YML file because it's not Windows OS: " + yamlFilePath);
            return false;
        }
        ConsoleLogger.info("Analyzing file for Windows paths: " + yamlFilePath);
        try {
            byte[] bytes = Files.readAllBytes(yamlFilePath);
            String originalContent = new String(bytes, StandardCharsets.UTF_8);
            ConsoleLogger.debug("File content read: " + yamlFilePath + " (" + bytes.length + " bytes)");
            String originalHash = this.hashContent(originalContent);
            String storedHash = this.fileHashes.getOrDefault(yamlFilePath, "");
            int backslashCount = originalContent.length() - originalContent.replace("\\", "").length();
            if (backslashCount == 0) {
                ConsoleLogger.info("No Windows paths (backslashes) found in: " + yamlFilePath);
                if (!originalHash.equals(storedHash)) {
                    this.fileHashes.put(yamlFilePath, originalHash);
                    ConsoleLogger.debug("Updated hash for unchanged file: " + yamlFilePath);
                }
                return false;
            }
            ConsoleLogger.info("Found " + backslashCount + " Windows backslashes in: " + yamlFilePath + " - converting to Unix format");
            String updatedContent = originalContent.replace("\\", "/");
            int remainingBackslashes = updatedContent.length() - updatedContent.replace("\\", "").length();
            ConsoleLogger.info("After conversion: " + remainingBackslashes + " backslashes remain" + (remainingBackslashes > 0 ? " (possible escaping issues)" : ""));
            String newHash = this.hashContent(updatedContent);
            ConsoleLogger.debug("File hash comparison for " + yamlFilePath + ":");
            ConsoleLogger.debug(" - Original file hash: " + originalHash);
            ConsoleLogger.debug(" - Stored hash: " + storedHash);
            ConsoleLogger.debug(" - New content hash: " + newHash);
            if (!originalHash.equals(storedHash) || !originalHash.equals(newHash)) {
                ConsoleLogger.info("Content changed - writing updates to: " + yamlFilePath);
                Files.write(yamlFilePath, updatedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.fileHashes.put(yamlFilePath, newHash);
                ConsoleLogger.info("Successfully converted Windows paths in: " + yamlFilePath);
                return true;
            }
            ConsoleLogger.info("No effective changes needed - file already converted: " + yamlFilePath);
            return false;
        }
        catch (IOException e) {
            ConsoleLogger.error("Failed to convert paths in YAML file: " + yamlFilePath + " - " + e.getMessage());
            e.printStackTrace(System.err);
            return false;
        }
        catch (Exception e) {
            ConsoleLogger.error("Unexpected error converting paths in YAML file: " + yamlFilePath + " - " + e.getMessage());
            e.printStackTrace(System.err);
            return false;
        }
    }

    public void watch() {
        ConsoleLogger.info("DirectoryWatcher starting to monitor for file changes...");
        ConsoleLogger.info("Watching " + this.watchKeys.size() + " directories.");
        block3: while (true) {
            try {
                while (true) {
                    WatchKey key;
                    Path dir;
                    if ((dir = this.watchKeys.get(key = this.watchService.take())) == null) {
                        ConsoleLogger.warn("Received watch event for unknown directory key");
                        continue;
                    }
                    ConsoleLogger.info("Detected events in directory: " + dir);
                    boolean shouldRestart = false;
                    int eventCount = 0;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        Path changedFile = dir.resolve((Path)event.context()).toAbsolutePath();
                        ConsoleLogger.info("Event " + ++eventCount + ": " + kind.name() + " on file: " + changedFile);
                        boolean isYamlFile = changedFile.toString().toLowerCase().endsWith(".yml");
                        if (isYamlFile && (kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_CREATE)) {
                            ConsoleLogger.info("Processing YAML file change: " + changedFile);
                            boolean converted = this.convertWindowsPathsToUnix(changedFile);
                            if (converted || changedFile.equals(this.otelConfigPath)) {
                                ConsoleLogger.info("Configuration updated in: " + changedFile + " - will trigger restart");
                                shouldRestart = true;
                            } else {
                                ConsoleLogger.info("No configuration changes detected in: " + changedFile);
                            }
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !changedFile.equals(this.muleAgentJksPath)) continue;
                        ConsoleLogger.info("JKS certificate file modified: " + changedFile);
                        this.certificateProcessor.processCertificates();
                        shouldRestart = true;
                    }
                    ConsoleLogger.info("Processed " + eventCount + " events for directory: " + dir);
                    boolean valid = key.reset();
                    if (!valid) {
                        ConsoleLogger.warn("Watch key is no longer valid, stopping monitoring for: " + dir);
                        break block3;
                    }
                    if (shouldRestart) {
                        ConsoleLogger.info("Changes require collector restart - initiating restart sequence");
                        this.restartCollector();
                        continue;
                    }
                    ConsoleLogger.info("No restart required after processing events");
                }
            }
            catch (InterruptedException e) {
                ConsoleLogger.error("Directory watching interrupted: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ConsoleLogger.error("Unexpected error in watch loop: " + e.getMessage());
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        if (this.watchService != null) {
            this.watchService.close();
        }
    }

    private void restartCollector() {
        try {
            CharSequence[] restartCommand;
            String scriptPath;
            String muleHome = System.getProperty("muleHome");
            if (muleHome == null) {
                System.err.println("muleHome system property is not set.");
                return;
            }
            if (this.isWindows) {
                scriptPath = muleHome + "\\am\\bin\\am.ps1";
                restartCommand = new String[]{"powershell", "-ExecutionPolicy", "Bypass", "-File", scriptPath, "restart"};
            } else {
                scriptPath = muleHome + "/am/bin/am restart";
                restartCommand = new String[]{"sh", "-c", scriptPath};
            }
            ConsoleLogger.debug("Restart command: " + String.join((CharSequence)" ", restartCommand));
            ConsoleLogger.info("Restarting OpenTelemetry Collector...");
            ProcessBuilder processBuilder = new ProcessBuilder((String[])restartCommand);
            processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(Paths.get(muleHome, "am", "logs", "directorywatcher.err").toFile()));
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(Paths.get(muleHome, "am", "logs", "directorywatcher.log").toFile()));
            Process process = processBuilder.start();
            ConsoleLogger.info("Restart command started... now waiting");
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                boolean isRunning = this.isOtelCollectorRunning();
                if (isRunning) {
                    ConsoleLogger.info("OpenTelemetry Collector restarted successfully.");
                } else {
                    System.err.println("OpenTelemetry Collector failed to start.");
                }
            } else {
                System.err.println("Error restarting OpenTelemetry Collector. Exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            System.err.println("Error during OpenTelemetry Collector restart: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOtelCollectorRunning() throws IOException {
        try (BufferedReader reader = null;){
            String line;
            CharSequence[] processSearchCommand;
            String muleHome = System.getProperty("muleHome");
            if (muleHome == null) {
                System.err.println("muleHome system property is not set.");
                boolean bl = false;
                return bl;
            }
            if (this.isWindows) {
                String scriptPath = muleHome + "\\am\\bin\\am.ps1";
                processSearchCommand = new String[]{"powershell", "-ExecutionPolicy", "Bypass", "-File", scriptPath, "status"};
            } else {
                String psGrepCommand = "ps aux | grep otel-collector | grep -v grep";
                processSearchCommand = new String[]{"sh", "-c", psGrepCommand};
            }
            ConsoleLogger.debug("Looking for otel-collector process by running : " + String.join((CharSequence)" ", processSearchCommand));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])processSearchCommand);
            Process process = processBuilder.start();
            if (this.isWindows) {
                int exitCode = process.waitFor();
                boolean bl = exitCode == 0;
                return bl;
            }
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("otel")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void main(String[] args) {
        try {
            DirectoryWatcher watcher = new DirectoryWatcher();
            watcher.watch();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

