/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.AdaptiveConfigImpl;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.PropertiesUtil;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.data.StringNamePath;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EventProcessorConfigImpl
implements EventProcessorConfig {
    public static final char MULTI_VALUE_SEPARATOR = ',';
    public static final char PROPERTY_KEY_SEPARATOR = '.';
    public static final String LIMITER_STRATEGY_NAME = "limiter.strategy.name";
    public static final String LIMITER_STRATEGY_CONTAINER_SIZE = "limiter.strategy.container-size";
    public static final String LIMITER_OUTPUT_MAXIMUM = "limiter.output.size";
    public static final String LIMITER_INPUT_COLLASPSEABLE_DIMENSIONS = "limiter.input.collapsible-dimensions";
    public static final String LIMITER_INPUT_RETAINING_DIMENSIONS = "limiter.input.retaining-dimensions";
    public static final String LIMITER_INPUT_LONG_METRIC_DIMENSIONS = "limiter.input.long-metric-dimensions";
    public static final String LIMITER_INPUT_DOUBLE_METRIC_DIMENSIONS = "limiter.input.double-metric-dimensions";
    public static final String LIMITER_ADAPTIVE_CONFIG_PREFIX = "limiter.strategy.adaptive.";
    public static final String PER_DIM_ADAPTIVE_CONFIG_NAME = "dimension";
    private static final int DEFAULT_MAX_OUTPUT = 100;
    private static final NamePath[] EMPTY_PATH_ARRAY = new NamePath[0];
    private StrategyType strategy;
    private int maxOutput = 100;
    private int containerSize = 1000;
    private Set<NamePath> collapsibleDimensions;
    private Set<NamePath> retainingDimensions;
    private Set<NamePath> longMetricDimensions;
    private Set<NamePath> doubleMetricDimensions;
    private final AdaptiveConfigImpl defaultAdaptiveConfig = new AdaptiveConfigImpl();
    private final Map<NamePath, AdaptiveConfigImpl> adaptiveConfig = new HashMap<NamePath, AdaptiveConfigImpl>();
    private transient NamePath[] collapsibleDimensionArray = EMPTY_PATH_ARRAY;
    private transient NamePath[] retainingDimensionArray = EMPTY_PATH_ARRAY;
    private transient NamePath[] longMetricDimensionArray = EMPTY_PATH_ARRAY;
    private transient NamePath[] doubleMetricDimensionArray = EMPTY_PATH_ARRAY;

    public void setProperties(Properties properties) {
        this.setConfiguration(properties);
    }

    public void setConfiguration(Properties config) {
        String strategyName = PropertiesUtil.getString(config, LIMITER_STRATEGY_NAME, null);
        if (strategyName != null) {
            StrategyType s = StrategyType.fromName(strategyName);
            if (s == null) {
                throw new IllegalArgumentException(strategyName + " is not a valid strategy.");
            }
            this.strategy = s;
        }
        this.maxOutput = PropertiesUtil.getInt(config, LIMITER_OUTPUT_MAXIMUM, this.maxOutput);
        this.containerSize = PropertiesUtil.getInt(config, LIMITER_STRATEGY_CONTAINER_SIZE, this.containerSize);
        NamePath[] pathArray = this.toNamePaths(config, LIMITER_INPUT_COLLASPSEABLE_DIMENSIONS);
        HashSet<NamePath> dimensionSet = new HashSet<NamePath>();
        dimensionSet.addAll(Arrays.asList(pathArray));
        this.setCollapsibleDimensions(dimensionSet);
        pathArray = this.toNamePaths(config, LIMITER_INPUT_RETAINING_DIMENSIONS);
        dimensionSet = new HashSet();
        dimensionSet.addAll(Arrays.asList(pathArray));
        this.setRetainingDimensions(dimensionSet);
        pathArray = this.toNamePaths(config, LIMITER_INPUT_LONG_METRIC_DIMENSIONS);
        dimensionSet = new HashSet();
        dimensionSet.addAll(Arrays.asList(pathArray));
        this.setLongMetricDimensions(dimensionSet);
        pathArray = this.toNamePaths(config, LIMITER_INPUT_DOUBLE_METRIC_DIMENSIONS);
        dimensionSet = new HashSet();
        dimensionSet.addAll(Arrays.asList(pathArray));
        this.setDoubleMetricDimensions(dimensionSet);
        this.defaultAdaptiveConfig.fromConfiguration(config, LIMITER_ADAPTIVE_CONFIG_PREFIX);
        this.parsePerDimAdaptiveConfig(config);
    }

    private void parsePerDimAdaptiveConfig(Properties config) {
        this.adaptiveConfig.clear();
        HashMap<Integer, Properties> configByIndex = new HashMap<Integer, Properties>();
        Iterator<String> iter = PropertiesUtil.findKeys(config, LIMITER_ADAPTIVE_CONFIG_PREFIX.substring(0, LIMITER_ADAPTIVE_CONFIG_PREFIX.length() - 1));
        while (iter.hasNext()) {
            String key = iter.next();
            String[] tokens = StringUtils.split((String)key, (char)'.');
            Integer configIndex = null;
            try {
                configIndex = new Integer(tokens[3]);
            }
            catch (Exception e) {
                continue;
            }
            if (tokens.length <= 4) continue;
            Properties perDimConfig = (Properties)configByIndex.get(configIndex);
            if (perDimConfig == null) {
                perDimConfig = new Properties();
                configByIndex.put(configIndex, perDimConfig);
            }
            Object[] newTokens = Arrays.copyOfRange(tokens, 4, tokens.length);
            perDimConfig.put(StringUtils.join((Object[])newTokens, (char)'.'), PropertiesUtil.getString(config, key, null));
        }
        for (Integer index : configByIndex.keySet()) {
            Properties perDimConfig = (Properties)configByIndex.get(index);
            if (perDimConfig != null && perDimConfig.containsKey(PER_DIM_ADAPTIVE_CONFIG_NAME)) {
                NamePath namePath = StringNamePath.fromString(PropertiesUtil.getString(perDimConfig, PER_DIM_ADAPTIVE_CONFIG_NAME, null));
                AdaptiveConfigImpl dimensionalConfig = new AdaptiveConfigImpl(this.defaultAdaptiveConfig);
                dimensionalConfig.fromConfiguration(perDimConfig, "");
                this.adaptiveConfig.put(namePath, dimensionalConfig);
                continue;
            }
            throw new IllegalArgumentException("Per dimensional configuration index " + index + " does not have a dimension name");
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        this.toConfiguration(properties);
        return properties;
    }

    public void toConfiguration(Properties config) {
        config.setProperty(LIMITER_STRATEGY_NAME, this.strategy.getName());
        config.setProperty(LIMITER_OUTPUT_MAXIMUM, Integer.toString(this.maxOutput));
        config.setProperty(LIMITER_STRATEGY_CONTAINER_SIZE, Integer.toString(this.containerSize));
        this.toConfiguration(config, LIMITER_INPUT_COLLASPSEABLE_DIMENSIONS, this.collapsibleDimensions);
        this.toConfiguration(config, LIMITER_INPUT_RETAINING_DIMENSIONS, this.retainingDimensions);
        this.toConfiguration(config, LIMITER_INPUT_LONG_METRIC_DIMENSIONS, this.longMetricDimensions);
        this.toConfiguration(config, LIMITER_INPUT_DOUBLE_METRIC_DIMENSIONS, this.doubleMetricDimensions);
        this.defaultAdaptiveConfig.toConfiguration(config, LIMITER_ADAPTIVE_CONFIG_PREFIX);
        StringNamePath[] path = this.adaptiveConfig.keySet().toArray(new StringNamePath[this.adaptiveConfig.size()]);
        Arrays.sort(path, StringNamePath.CASE_INSENSITIVE_NAME_PATH_COMPARATOR);
        for (int i = 0; i < path.length; ++i) {
            AdaptiveConfigImpl perDimCfg = this.adaptiveConfig.get(path[i]);
            config.setProperty(LIMITER_ADAPTIVE_CONFIG_PREFIX + i + '.' + PER_DIM_ADAPTIVE_CONFIG_NAME, new StringNamePath(path[i]).toString());
            if (perDimCfg == null) continue;
            perDimCfg.toConfiguration(config, LIMITER_ADAPTIVE_CONFIG_PREFIX + i + '.');
        }
    }

    private void toConfiguration(Properties config, String key, Set<NamePath> value) {
        config.remove(key);
        if (value == null || value.size() == 0) {
            return;
        }
        NamePath[] sortedValues = value.toArray(new NamePath[value.size()]);
        Arrays.sort(sortedValues, StringNamePath.CASE_INSENSITIVE_NAME_PATH_COMPARATOR);
        String[] values = new String[sortedValues.length];
        for (int i = 0; i < sortedValues.length; ++i) {
            values[i] = new StringNamePath(sortedValues[i]).toString();
        }
        config.setProperty(key, PropertiesUtil.convertToList(values, ','));
    }

    private NamePath[] toNamePaths(Properties config, String propertyName) {
        String[] flatNamePaths = PropertiesUtil.getStringArray(config, propertyName, ',', null);
        if (flatNamePaths == null) {
            return EMPTY_PATH_ARRAY;
        }
        NamePath[] result = new NamePath[flatNamePaths.length];
        for (int i = 0; i < flatNamePaths.length; ++i) {
            result[i] = flatNamePaths[i] == null ? null : new StringNamePath(flatNamePaths[i]);
        }
        return result;
    }

    @Override
    public StrategyType getStrategy() {
        return this.strategy;
    }

    public void setStrategy(StrategyType strategy) {
        this.strategy = strategy;
    }

    @Override
    public int getMaxOutput() {
        return this.maxOutput;
    }

    public void setMaxOutput(int maxOutput) {
        if (maxOutput < 0) {
            throw new IllegalArgumentException("Can only have a non-negative maxOutputSize");
        }
        this.maxOutput = maxOutput;
    }

    @Override
    @Deprecated
    public int getSamplingSize() {
        return this.defaultAdaptiveConfig.getPerDimMaximumN();
    }

    @Deprecated
    public void setSamplingSize(int samplingSize) {
        this.defaultAdaptiveConfig.setPerDimMaximumN(samplingSize);
    }

    @Override
    public int getContainerSize() {
        return this.containerSize;
    }

    public void setContainerSize(int containerSize) {
        if (containerSize <= 0) {
            throw new IllegalArgumentException("Can only have a positive containerSize");
        }
        this.containerSize = containerSize;
    }

    @Override
    @Deprecated
    public double getDistributionBound() {
        return this.defaultAdaptiveConfig.getCombinedEventLowerBound();
    }

    @Override
    public AdaptiveConfigImpl getAdaptiveConfig() {
        return this.defaultAdaptiveConfig;
    }

    @Deprecated
    public void setDistributionBound(double distributionBound) {
        this.defaultAdaptiveConfig.setCombinedEventLowerBound(distributionBound);
    }

    public Set<NamePath> getCollapsibleDimensions() {
        return this.collapsibleDimensions != null ? Collections.unmodifiableSet(this.collapsibleDimensions) : null;
    }

    public void setCollapsibleDimensions(Set<NamePath> collapsibleDimensions) {
        this.collapsibleDimensions = collapsibleDimensions;
        this.collapsibleDimensionArray = this.getSortedArray(collapsibleDimensions);
    }

    public Set<NamePath> getRetainingDimensions() {
        return this.retainingDimensions != null ? Collections.unmodifiableSet(this.retainingDimensions) : null;
    }

    public void setRetainingDimensions(Set<NamePath> retainingDimensions) {
        this.retainingDimensions = retainingDimensions;
        this.retainingDimensionArray = this.getSortedArray(retainingDimensions);
    }

    public Set<NamePath> getLongMetricDimensions() {
        return this.longMetricDimensions != null ? Collections.unmodifiableSet(this.longMetricDimensions) : null;
    }

    public void setLongMetricDimensions(Set<NamePath> metricDimensions) {
        this.longMetricDimensions = metricDimensions;
        this.longMetricDimensionArray = this.getSortedArray(metricDimensions);
    }

    public Set<NamePath> getDoubleMetricDimensions() {
        return this.doubleMetricDimensions != null ? Collections.unmodifiableSet(this.doubleMetricDimensions) : null;
    }

    public void setDoubleMetricDimensions(Set<NamePath> metricDimensions) {
        this.doubleMetricDimensions = metricDimensions;
        this.doubleMetricDimensionArray = this.getSortedArray(metricDimensions);
    }

    @Override
    public NamePath[] getCollapsibleDims() {
        return this.collapsibleDimensionArray;
    }

    @Override
    public NamePath[] getRetainingDims() {
        return this.retainingDimensionArray;
    }

    @Override
    public NamePath[] getLongMetricDims() {
        return this.longMetricDimensionArray;
    }

    @Override
    public NamePath[] getDoubleMetricDims() {
        return this.doubleMetricDimensionArray;
    }

    private NamePath[] getSortedArray(Set<NamePath> namePaths) {
        if (namePaths != null) {
            NamePath[] result = namePaths.toArray(new NamePath[namePaths.size()]);
            Arrays.sort(result, StringNamePath.CASE_INSENSITIVE_NAME_PATH_COMPARATOR);
            return result;
        }
        return EMPTY_PATH_ARRAY;
    }

    public Map<NamePath, AdaptiveConfigImpl> getPerDimAdaptiveConfig() {
        return this.adaptiveConfig;
    }

    public String toString() {
        Properties config = new Properties();
        this.toConfiguration(config);
        StringWriter writer = new StringWriter();
        try {
            config.store(writer, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "EventProcessorConfig [\n" + writer.toString() + "]";
    }
}

