/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    public static final String SEMVER_PATTERN = "(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).*?";
    private final int major;
    private final int minor;
    private final int patch;

    private Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version create(File directory, String patternFile, String cannotDetectVersionMsg) {
        String versionStr = Version.getVersionStr(directory, patternFile, cannotDetectVersionMsg);
        String[] partsStr = versionStr.split("\\.");
        if (partsStr.length != 3) {
            throw Version.invalidVersionString(versionStr);
        }
        try {
            ArrayList<Integer> parts = new ArrayList<Integer>();
            for (String s : partsStr) {
                parts.add(Version.parseVersionInt(s));
            }
            return new Version((Integer)parts.get(0), (Integer)parts.get(1), (Integer)parts.get(2));
        }
        catch (NumberFormatException e) {
            throw Version.invalidVersionString(versionStr);
        }
    }

    private static String getVersionStr(File directory, final String patternFile, String cannotDetectVersionMsg) {
        File file;
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(patternFile);
            }
        });
        if (files != null && files.length > 0 && (file = files[0]).isFile()) {
            Pattern pattern = Pattern.compile(SEMVER_PATTERN, 8);
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.find()) {
                throw new IllegalArgumentException(cannotDetectVersionMsg);
            }
            return matcher.group();
        }
        throw new IllegalArgumentException(cannotDetectVersionMsg);
    }

    private static IllegalArgumentException invalidVersionString(String versionStr) {
        return new IllegalArgumentException(String.format("Invalid version string '%s'", versionStr));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    private static int parseVersionInt(String s) {
        return Integer.parseInt(s.replace("-SNAPSHOT", ""));
    }
}

