/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DownloaderProxyClient;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.digests.MD5Digest;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.encoders.Hex;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class CountryDbDownloader {
    private static final Logger LOGGER = LogManager.getLogger(CountryDbDownloader.class);
    @Inject
    private Configuration configuration;
    @Inject
    private DownloaderProxyClient proxyClient;

    public void download() {
        block12: {
            try {
                String downloadUrl = this.configuration.getCountryDbDownloadUrl();
                String downloadFileChecksum = this.configuration.getCountryDbChecksum();
                if (downloadUrl == null || downloadFileChecksum == null || this.configuration.isCountryDbCurrent()) break block12;
                LOGGER.info("Downloading Country database");
                Path countryDbPath = this.configuration.getCountryDbPath();
                String zipFilename = StringUtils.substringAfterLast((String)downloadUrl, (String)"/");
                String zipTmpFilename = zipFilename + ".tmp";
                File zipTmpFile = countryDbPath.resolve(zipTmpFilename).toFile();
                boolean proxyConfigured = this.proxyClient.readProxyConfig();
                if (proxyConfigured) {
                    this.proxyClient.downloadToFile(downloadUrl, zipTmpFile);
                } else {
                    FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)zipTmpFile);
                }
                Thread.sleep(1000L);
                MD5Digest digest = new MD5Digest();
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(Files.newInputStream(zipTmpFile.toPath(), new OpenOption[0]));){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                byte[] hash = new byte[digest.getDigestSize()];
                digest.doFinal(hash, 0);
                String hVal = new String(Hex.encode(hash));
                LOGGER.info("Temp file hash value: " + hVal);
                if (downloadFileChecksum.equals(hVal)) {
                    LOGGER.info("Checksum matched. Enabling country lookup with database file {}.", (Object)zipFilename);
                    CountryDbDownloader.deleteExistingCountryDbFiles(this.configuration.getCountryDbPath());
                    FileUtils.moveFile((File)zipTmpFile, (File)countryDbPath.resolve(zipFilename).toFile());
                    this.configuration.resetApiCountryMetricPipeline();
                } else {
                    LOGGER.error("Checksum mismatch");
                    FileUtils.deleteQuietly((File)zipTmpFile);
                }
            }
            catch (Exception e) {
                LOGGER.error("Country database download failed", (Throwable)e);
            }
        }
    }

    static void deleteExistingCountryDbFiles(Path countryDbPath) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(countryDbPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return Configuration.LOCATION_DB_MATCHER.matches(entry);
            }
        });){
            for (Path filePath : stream) {
                Files.delete(filePath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete existing location database files", (Throwable)e);
        }
    }
}

