/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.PayloadStatistics;

public class PayloadStatsCollector
implements EventProducer<Fact> {
    private String appId;
    private String sessionId;
    private AllStatistics allStats;
    private Set<String> whitelist;
    private Set<String> blacklist;

    public PayloadStatsCollector(MuleContext muleContext, String appId, String sessionId, Set<String> whitelist, Set<String> blacklist) {
        this.allStats = muleContext.getStatistics();
        this.sessionId = sessionId;
        this.appId = appId;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public boolean enablePayloadStats() {
        try {
            if (this.allStats != null) {
                this.allStats.enablePayloadStatistics(true);
                this.allStats.getPayloadStatistics();
                return true;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return false;
    }

    public boolean disablePayloadStats() {
        try {
            if (this.allStats != null && this.allStats.isPayloadStatisticsEnabled()) {
                this.allStats.enablePayloadStatistics(false);
                return true;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<Event<Fact>> produce() {
        ArrayList<Event<Fact>> result = new ArrayList<Event<Fact>>();
        for (PayloadStatistics ps : this.allStats.getPayloadStatistics()) {
            String component = ps.getComponentIdentifier();
            int pos = component.indexOf(58);
            if (pos > 0) {
                component = component.substring(0, pos);
            }
            if (!this.whitelist.isEmpty() && !this.whitelist.contains(component) || this.blacklist.contains(component)) continue;
            long count = ps.getInvocationCount();
            long inCount = ps.getInputObjectCount();
            long outCount = ps.getOutputObjectCount();
            long inSize = ps.getInputByteCount();
            long outSize = ps.getOutputByteCount();
            if (count == 0L && inCount == 0L && outCount == 0L && inSize == 0L && outSize == 0L) continue;
            Fact fact = new Fact();
            fact.setDimension("app_id", this.appId);
            fact.setDimension("app_session", this.sessionId);
            fact.setDimension("component", ps.getComponentIdentifier());
            fact.setDimension("location", ps.getComponentLocation());
            fact.setLongMetric("invocation_count", count);
            fact.setLongMetric("input_count", inCount);
            fact.setLongMetric("output_count", outCount);
            fact.setLongMetric("input_size", inSize);
            fact.setLongMetric("output_size", outSize);
            result.add(new Event<Fact>(fact));
        }
        return result;
    }
}

