/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import com.mulesoft.dias.mule.agent.AgentEncryptionException;
import com.mulesoft.dias.mule.agent.EncryptionService;
import com.mulesoft.dias.mule.agent.EncryptionUtils;
import com.mulesoft.dias.mule.agent.SecretAlreadyEncryptedException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

@Singleton
@Named(value="DefaultEncryptionService")
public class DefaultEncryptionService
implements EncryptionService {
    public static final String MASTER_PASSWORD_PROPERTY = "mule.agent.configuration.password";
    public static final String MASTER_PASSWORD_ENVVAR = "AGENT_VAR_master_password";
    private StandardPBEStringEncryptor encryptor;

    public DefaultEncryptionService() {
        String masterPassword = this.getMasterPassword();
        this.encryptor = new StandardPBEStringEncryptor();
        this.encryptor.setAlgorithm("PBEWITHSHA1ANDDESEDE");
        this.encryptor.setPassword(masterPassword);
    }

    @Override
    public String encrypt(String value) throws AgentEncryptionException {
        if (EncryptionUtils.isEncryptedWithPBECipher(value)) {
            throw new SecretAlreadyEncryptedException("The secret is encrypted");
        }
        StringBuilder result = new StringBuilder();
        result.append("![");
        result.append("PBEWITHSHA1ANDDESEDE");
        result.append(",");
        try {
            String encrypted = this.encryptor.encrypt(value);
            result.append(encrypted);
        }
        catch (EncryptionOperationNotPossibleException ex) {
            throw new AgentEncryptionException("Error encrypting the value.", ex);
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public String decrypt(String value) throws AgentEncryptionException {
        return this.decrypt(value.toCharArray());
    }

    @Override
    public String decrypt(char[] value) throws AgentEncryptionException {
        StringBuilder valueAsString = new StringBuilder().append(value);
        if (!EncryptionUtils.isEncryptedWithPBECipher(valueAsString.toString())) {
            if (EncryptionUtils.isEncryptedWithUnknownCipher(valueAsString.toString())) {
                throw new AgentEncryptionException("Error decrypting the value, it's not recognized as a valid encrypted value.");
            }
            return valueAsString.toString();
        }
        String encryptedValue = EncryptionUtils.getEncryptedValue(valueAsString.toString());
        try {
            return this.encryptor.decrypt(encryptedValue);
        }
        catch (EncryptionOperationNotPossibleException ex) {
            throw new AgentEncryptionException("Error decrypting the value.", ex);
        }
    }

    String getMasterPassword() {
        if (StringUtils.isNotBlank(System.getProperty(MASTER_PASSWORD_PROPERTY))) {
            return System.getProperty(MASTER_PASSWORD_PROPERTY);
        }
        return System.getenv(MASTER_PASSWORD_ENVVAR);
    }
}

