/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.dilithium;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Set;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.DilithiumPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.DilithiumPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.spec.DilithiumParameterSpec;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCDilithiumPrivateKey
implements DilithiumPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient DilithiumPrivateKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;
    private transient ASN1Set attributes;

    public BCDilithiumPrivateKey(DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters) {
        this.init(dilithiumPrivateKeyParameters, null);
    }

    public BCDilithiumPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init((DilithiumPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo), privateKeyInfo.getAttributes());
    }

    private void init(DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters, ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
        this.params = dilithiumPrivateKeyParameters;
        this.algorithm = Strings.toUpperCase(dilithiumPrivateKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCDilithiumPrivateKey) {
            BCDilithiumPrivateKey bCDilithiumPrivateKey = (BCDilithiumPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCDilithiumPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedPrivateKeyInfo((AsymmetricKeyParameter)this.params, (ASN1Set)this.attributes);
        }
        return Arrays.clone(this.encoding);
    }

    public DilithiumPublicKey getPublicKey() {
        return new BCDilithiumPublicKey(this.params.getPublicKeyParameters());
    }

    public DilithiumParameterSpec getParameterSpec() {
        return DilithiumParameterSpec.fromName((String)this.params.getParameters().getName());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    DilithiumPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

