/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.sphincsplus;

import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.ASN1Set;
import com.mulesoft.analytics.collector.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.mulesoft.analytics.collector.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSPlusPrivateKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSPlusPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.provider.sphincsplus.BCSPHINCSPlusPublicKey;
import com.mulesoft.analytics.collector.shaded.bouncycastle.pqc.jcajce.spec.SPHINCSPlusParameterSpec;
import com.mulesoft.analytics.collector.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSPHINCSPlusPrivateKey
implements PrivateKey,
SPHINCSPlusPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient SPHINCSPlusPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSPHINCSPlusPrivateKey(SPHINCSPlusPrivateKeyParameters sPHINCSPlusPrivateKeyParameters) {
        this.params = sPHINCSPlusPrivateKeyParameters;
    }

    public BCSPHINCSPlusPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SPHINCSPlusPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSPHINCSPlusPrivateKey) {
            BCSPHINCSPlusPrivateKey bCSPHINCSPlusPrivateKey = (BCSPHINCSPlusPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSPHINCSPlusPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS+";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.params, (ASN1Set)this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SPHINCSPlusPublicKey getPublicKey() {
        return new BCSPHINCSPlusPublicKey(new SPHINCSPlusPublicKeyParameters(this.params.getParameters(), this.params.getPublicKey()));
    }

    public SPHINCSPlusParameterSpec getParameterSpec() {
        return SPHINCSPlusParameterSpec.fromName((String)this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    SPHINCSPlusPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

