/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.processor;

import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessor;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.EventProcessorResult;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.data.ValueVector;
import com.mulesoft.analytics.limiter.processor.EventLimiter;
import com.mulesoft.analytics.limiter.processor.EventLimiterImpl;
import com.mulesoft.analytics.limiter.processor.EventProcessorResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class EventProcessorImpl
implements EventProcessor {
    private EventProcessorConfig config;
    private int inputEventCount = 0;
    private int outputEventCount = 0;
    private Map<ValueVector, EventLimiter> outerMap = new LinkedHashMap<ValueVector, EventLimiter>();

    public EventProcessorImpl(EventProcessorConfig config) {
        this.setConfiguration(config);
    }

    @Override
    public void setConfiguration(EventProcessorConfig configuration) {
        this.config = configuration;
    }

    @Override
    public EventProcessorConfig getConfiguration() {
        return this.config;
    }

    @Override
    public void append(Collection<? extends UserEvent> events) {
        this.inputEventCount += events.size();
        NamePath[] retainedDims = this.config.getRetainingDims();
        for (UserEvent userEvent : events) {
            ValueVector v = new ValueVector(userEvent.getDimensionValues(retainedDims));
            EventLimiter innerMap = this.outerMap.get(v);
            if (innerMap == null) {
                innerMap = new EventLimiterImpl(this.config);
                this.outerMap.put(v, innerMap);
            }
            innerMap.append(userEvent);
        }
    }

    @Override
    public int getInputEventCount() {
        return this.inputEventCount;
    }

    @Override
    public int getOutputEventCount() {
        return this.outputEventCount;
    }

    @Override
    public EventProcessorResult retrieveProcessorResult() {
        ArrayList<EventLimiterResult> results = new ArrayList<EventLimiterResult>();
        for (Map.Entry<ValueVector, EventLimiter> e : this.outerMap.entrySet()) {
            EventLimiter limiter = e.getValue();
            results.add(limiter.retrieveLimiterResult());
        }
        EventProcessorResultImpl procResult = new EventProcessorResultImpl(this.inputEventCount, results);
        return procResult;
    }

    public String toString() {
        return "EventProcessorImpl with config = " + this.config;
    }
}

