/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class TrustManager {
    private KeyStore keyStore;
    private TrustManagerFactory trustManagerFactory;

    public TrustManager(String instance) throws KeyStoreException, NoSuchAlgorithmException {
        this.keyStore = KeyStore.getInstance(instance);
        this.trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void init(String path, char[] password) throws IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        this.keyStore.load(new FileInputStream(new File(path)), password);
        this.trustManagerFactory.init(this.keyStore);
    }

    public javax.net.ssl.TrustManager[] getTrustManagers() {
        return this.trustManagerFactory.getTrustManagers();
    }
}

